package yangtz.cs.liu.campus.domain.schoolexam;

import com.core.domain.OurBaseEntity;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;

import javax.validation.constraints.NotBlank;

@Data
public class SchoolExamDetail extends OurBaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 考试id */
    private Long examId;

    /** 学生姓名 */
    @NotBlank(message = "学生姓名不能为空")
    @Excel(name = "学生姓名")
    private String studentName;

    /** 学生id */
    private Long studentId;

    /** 身份证号 */
    @NotBlank(message = "身份证号不能为空")
    @Excel(name = "身份证号")
    private String idCard;

    /** 语文成绩 */
    @Excel(name = "语文成绩")
    private String chinese;

    /** 数学成绩 */
    @Excel(name = "数学成绩")
    private String math;

    /** 英语成绩 */
    @Excel(name = "英语成绩")
    private String english;

    /** 历史成绩 */
    @Excel(name = "历史成绩")
    private String history;

    /** 思想政治成绩 */
    @Excel(name = "思想政治成绩")
    private String politicalThought;

    /** 地理成绩 */
    @Excel(name = "地理成绩")
    private String geography;

    /** 化学成绩 */
    @Excel(name = "化学成绩")
    private String chemistry;

    /** 物理成绩 */
    @Excel(name = "物理成绩")
    private String physics;

    /** 生物成绩 */
    @Excel(name = "生物成绩")
    private String biology;

    /** 体育成绩 */
    @Excel(name = "体育成绩")
    private String sports;

    /** 美术成绩 */
    @Excel(name = "美术成绩")
    private String painting;

    /** 音乐成绩 */
    @Excel(name = "音乐成绩")
    private String music;

    /** 总分 */
    @Excel(name = "总分")
    private String totalScore;

    /** 备注 */
    @Excel(name = "备注")
    private String remarks;

}
