package yangtz.cs.liu.campus.domain.schoolcalendar;

import com.baomidou.mybatisplus.annotation.TableLogic;
import com.core.domain.OurBaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.ruoyi.common.annotation.Excel;
import lombok.Data;

import java.util.Date;


@Data
public class SchoolCalendar extends OurBaseEntity {


    /** 校历名称 */
    @Excel(name = "校历名称")
    private String calendarName;

    /** 开始时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "开始时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date startTime;

    /** 结束时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "结束时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date endTime;

    /** 1 校历 2 部门历 */
    @Excel(name = "1 校历 2 部门历")
    private char calendarType;

    /** 所属部门id */
    @Excel(name = "所属部门id")
    private Long deptId;

    /** 状态 */
    @Excel(name = "状态")
    private char status;



}
