package yangtz.cs.liu.campus.domain.schoolbudget;

import java.math.BigDecimal;

import com.core.domain.OurBaseEntity;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;

/**
 * school_budget_details
 *
 * @author wengxiu
 * @date 2023-01-05
 */
@Data
public class SchoolBudgetDetails extends OurBaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 预算项目主键 */
    //@Excel(name = "预算项目主键")
    private Long budgetId;

    /** 项目支出明细 */
    @Excel(name = "项目支出明细")
    private String budgetDetailed;

    /** 批复金额 */
    @Excel(name = "批复金额（万元）")
    private BigDecimal moneyDetailed;

    /** 说明 */
    //@Excel(name = "说明")
    private String remark;
}
