package yangtz.cs.liu.campus.domain.schoolbudget;

import java.math.BigDecimal;
import java.util.List;

import com.core.domain.OurBaseEntity;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.common.annotation.Excel;

/**
 * 预算项目对象 school_budget
 * 
 * @author wengxiu
 * @date 2023-01-05
 */
@Data
public class SchoolBudget extends OurBaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 预算年度 */
    @Excel(name = "预算年度")
    private String budgetYear;

    /** 部门ID科室 */
    @Excel(name = "部门ID科室")
    private Long deptId;

    /** 申请部门名称 */
    @Excel(name = "申请部门名称")
    private String deptName;

    /** 项目名称 */
    @Excel(name = "项目名称")
    private String budgetName;

    /** 是否政府采购(0是 1否) */
    @Excel(name = "是否政府采购(0是 1否)")
    private String isGov;

    /** 说明 */
    @Excel(name = "说明")
    private String remark;

    /** 批复金额 */
    @Excel(name = "批复金额")
    private BigDecimal giveMoney;
}
