package yangtz.cs.liu.campus.domain.schoolStudio;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;

/**
 * 录播室预约情况对象 school_studio_appointment
 *
 * @author ruoyi
 * @date 2023-07-10
 */
public class SchoolStudioAppointment extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 录播室预约主键id */
    private Long id;

    /** 录播室id */
    @Excel(name = "录播室id")
    private Long studioId;

    /** 录播室名称 */
    @Excel(name = "录播室名称")
    private String studioName;

    /** 预约日期 */
    @Excel(name = "预约日期", width = 30)
    private String appointmentTime;

    /** 预约节次 */
    @Excel(name = "预约节次")
    private String appointmentJc;

    /** 录播内容 */
    @Excel(name = "录播内容")
    private String studioContent;

    /** 预约人id */
    @Excel(name = "预约人id")
    private Long appointmentUserId;

    /** 预约人 */
    @Excel(name = "预约人")
    private String appointmentUserName;

    /** 申请时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "申请时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date applyTime;

    /** 状态（1-预约成功，2-已取消） */
    @Excel(name = "状态", readConverterExp = "1-预约成功，2-已取消")
    private String statu;

    private String startTime;

    private String endTime;

    public String getStartTime() {
        return startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public String getEndTime() {
        return endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public void setId(Long id)
    {
        this.id = id;
    }

    public Long getId()
    {
        return id;
    }
    public void setStudioId(Long studioId)
    {
        this.studioId = studioId;
    }

    public Long getStudioId()
    {
        return studioId;
    }
    public void setStudioName(String studioName)
    {
        this.studioName = studioName;
    }

    public String getStudioName()
    {
        return studioName;
    }
    public void setAppointmentTime(String appointmentTime)
    {
        this.appointmentTime = appointmentTime;
    }

    public String getAppointmentTime()
    {
        return appointmentTime;
    }
    public void setAppointmentJc(String appointmentJc)
    {
        this.appointmentJc = appointmentJc;
    }

    public String getAppointmentJc()
    {
        return appointmentJc;
    }
    public void setStudioContent(String studioContent)
    {
        this.studioContent = studioContent;
    }

    public String getStudioContent()
    {
        return studioContent;
    }
    public void setAppointmentUserId(Long appointmentUserId)
    {
        this.appointmentUserId = appointmentUserId;
    }

    public Long getAppointmentUserId()
    {
        return appointmentUserId;
    }
    public void setAppointmentUserName(String appointmentUserName)
    {
        this.appointmentUserName = appointmentUserName;
    }

    public String getAppointmentUserName()
    {
        return appointmentUserName;
    }
    public void setApplyTime(Date applyTime)
    {
        this.applyTime = applyTime;
    }

    public Date getApplyTime()
    {
        return applyTime;
    }
    public void setStatu(String statu)
    {
        this.statu = statu;
    }

    public String getStatu()
    {
        return statu;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
                .append("id", getId())
                .append("studioId", getStudioId())
                .append("studioName", getStudioName())
                .append("appointmentTime", getAppointmentTime())
                .append("appointmentJc", getAppointmentJc())
                .append("studioContent", getStudioContent())
                .append("appointmentUserId", getAppointmentUserId())
                .append("appointmentUserName", getAppointmentUserName())
                .append("applyTime", getApplyTime())
                .append("statu", getStatu())
                .toString();
    }
}
