package yangtz.cs.liu.campus.domain.schoolStudio;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;

/**
 * 录播室管理对象 school_studio
 *
 * @author ruoyi
 * @date 2023-07-10
 */
public class SchoolStudio extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 录播室主键id */
    private Long id;

    /** 录播室简称 */
    @Excel(name = "录播室简称")
    private String studioName;

    /** 录播室地点 */
    @Excel(name = "录播室地点")
    private String studioArea;

    /** 录播室状态（1-启用，2禁用） */
    @Excel(name = "录播室状态", readConverterExp = "1-启用，2-禁用")
    private String studioStatu;

    /** 创建人id */
    @Excel(name = "创建人id")
    private Long createById;

    /** 修改人id */
    @Excel(name = "修改人id")
    private Long updateById;

    /** 删除状态（1-已删除，0-未删除） */
    @Excel(name = "删除状态", readConverterExp = "1=-已删除，0-未删除")
    private String delFlg;

    public void setId(Long id)
    {
        this.id = id;
    }

    public Long getId()
    {
        return id;
    }
    public void setStudioName(String studioName)
    {
        this.studioName = studioName;
    }

    public String getStudioName()
    {
        return studioName;
    }
    public void setStudioArea(String studioArea)
    {
        this.studioArea = studioArea;
    }

    public String getStudioArea()
    {
        return studioArea;
    }
    public void setStudioStatu(String studioStatu)
    {
        this.studioStatu = studioStatu;
    }

    public String getStudioStatu()
    {
        return studioStatu;
    }
    public void setCreateById(Long createById)
    {
        this.createById = createById;
    }

    public Long getCreateById()
    {
        return createById;
    }
    public void setUpdateById(Long updateById)
    {
        this.updateById = updateById;
    }

    public Long getUpdateById()
    {
        return updateById;
    }
    public void setDelFlg(String delFlg)
    {
        this.delFlg = delFlg;
    }

    public String getDelFlg()
    {
        return delFlg;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
                .append("id", getId())
                .append("studioName", getStudioName())
                .append("studioArea", getStudioArea())
                .append("studioStatu", getStudioStatu())
                .append("createById", getCreateById())
                .append("createBy", getCreateBy())
                .append("createTime", getCreateTime())
                .append("updateById", getUpdateById())
                .append("updateBy", getUpdateBy())
                .append("updateTime", getUpdateTime())
                .append("delFlg", getDelFlg())
                .toString();
    }
}
