package yangtz.cs.liu.campus.domain.schoolInfo;

import java.util.Date;

import com.core.domain.OurBaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;
import org.springframework.validation.annotation.Validated;

import javax.validation.constraints.NotBlank;

/**
 * 信息采集详情对象 school_info_detail
 */
@Data
public class SchoolInfoDetail extends OurBaseEntity {
    private static final long serialVersionUID = 1L;

    /**
     * 主表id
     */
    //@Excel(name = "主表id")
    private Long infoId;

    /**
     * 身份证号
     */
    @Excel(name = "身份证号", width = 40)
    @NotBlank(message = "身份证号不能为空")
    private String idCard;

    /**
     * 学生姓名
     */
    @Excel(name = "学生姓名")
    @NotBlank(message = "学生名字不能为空")
    private String studentName;

    /**
     * 注册序号
     */
    @Excel(name = "注册序号", width = 30)
    @NotBlank(message = "注册序号不能为空")
    private String schoolNo;

    /**
     * 性别(0男 1女)
     */
    @Excel(name = "性别",combo = {"男","女"},readConverterExp = "0=男,1=女")
    private String sex;

    /**
     * 出生日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "出生日期", width = 30, dateFormat = "yyyy-MM-dd")
    private Date birthday;

    /**
     * 民族
     */
    @Excel(name = "民族",combo = {"汉族","壮族","回族","满族","维吾尔族","苗族","彝族","土家族","藏族",
            "蒙古族","侗族","布依族","瑶族","白族","朝鲜族","哈尼族","黎族","哈萨克族","傣族","畲族","傈僳族","东乡族",
            "仡佬族","拉祜族","佤族","水族","纳西族","羌族","土族","仫佬族","锡伯族","柯尔克孜族","景颇族","达斡尔族",
            "撒拉族","布朗族","毛南族","塔吉克族","普米族","阿昌族","怒族","鄂温克族","京族","基诺族","德昂族","保安族",
            "俄罗斯族","裕固族","乌孜别克族","门巴族","鄂伦春族","独龙族","赫哲族","高山族","珞巴族","塔塔尔族"})
    private String nation;

    /**
     * 省学籍辅号
     */
    @Excel(name = "省学籍辅号", width = 30)
    private String provincialNumber;

    /**
     * 全国学籍号
     */
    @Excel(name = "全国学籍号", width = 30)
    private String nationalNumber;

    /**
     * 联系电话
     */
    @Excel(name = "联系电话", width = 30)
    private String stuTelephone;

    /**
     * 现住地址
     */
    @Excel(name = "现住地址", width = 30)
    private String homeAddress;

    /**
     * 通讯地址
     */
    @Excel(name = "通讯地址", width = 30)
    private String postalAddress;

    /**
     * 出生地
     */
    @Excel(name = "出生地", width = 30)
    private String birthAddress;

    /**
     * 邮政编码
     */
    @Excel(name = "邮政编码")
    private String postalCode;

    /**
     * 籍贯
     */
    @Excel(name = "籍贯", width = 30)
    private String nativePlace;

    /**
     * 户口所在地
     */
    @Excel(name = "户口所在地", width = 30)
    private String registeredAddress;

    /**
     * 户口性质
     */
    @Excel(name = "户口性质",combo = {"农业户口","非农户口"},readConverterExp = "0=农业户口,1=非农户口")
    private String registeredType;

    /**
     * 初中学校
     */
    @Excel(name = "初中学校")
    private String juniorSchool;

    /**
     * 国家地区
     */
    @Excel(name = "国家地区")
    private String region;

    /**
     * 外语语种
     */
    @Excel(name = "外语语种")
    private String foreignLanguages;

    /**
     * 政治面貌
     */
    @Excel(name = "政治面貌",combo = {"中共党员","共青团员","群众"},readConverterExp = "0=中共党员,1=共青团员,2=群众")
    private String appearance;

    /**
     * 血型
     */
    @Excel(name = "血型")
    private String bloodType;

    /**
     * 健康状况
     */
    @Excel(name = "健康状况")
    private String health;

    /**
     * 港澳台侨
     */
    @Excel(name = "港澳台侨")
    private String otherRegions;

    /**
     * 流动人口状况
     */
    @Excel(name = "流动人口状况", width = 30)
    private String floatingPopulation;

    /**
     * 独生子女（0否 1是）
     */
    @Excel(name = "独生子女",combo = {"否","是"},readConverterExp = "0=否,1=是")
    private String onlyChild;

    /**
     * 性质（0普通 1音乐 2 体育 3美术 4书法）
     */
    @Excel(name = "性质",combo = {"普通","音乐","体育","美术","书法"},readConverterExp = "0=普通,1=音乐,2=体育,3=美术,4=书法")
    private String nature;

    /**
     * 接受资助状况
     */
    @Excel(name = "接受资助状况", width = 30)
    private String support;

    /**
     * 家长姓名1
     */
    @Excel(name = "家长姓名1")
    private String parentName1;

    /**
     * 家长关系1 0=父亲,1=母亲,2=爷爷,3=奶奶,4=叔叔,5=姑姑
     */
    @Excel(name = "家长关系1",combo = {"父亲","母亲","爷爷","奶奶","叔叔","姑姑"},readConverterExp = "0=父亲,1=母亲,2=爷爷,3=奶奶,4=叔叔,5=姑姑")
    private String relationship1;

    /**
     * 家长工作单位1
     */
    @Excel(name = "家长工作单位1", width = 30)
    private String workAddress1;

    /**
     * 家长联系地址1
     */
    @Excel(name = "家长联系地址1", width = 30)
    private String contactAddress1;

    /**
     * 家长联系电话1
     */
    @Excel(name = "家长联系电话1")
    private String telephone1;

    /**
     * 家长邮政编码1
     */
    @Excel(name = "家长邮政编码1")
    private String postalCode1;

    /**
     * 家长姓名2
     */
    @Excel(name = "家长姓名2")
    private String parentName2;

    /**
     * 家长关系2 0=父亲,1=母亲,2=爷爷,3=奶奶,4=叔叔,5=姑姑
     */
    @Excel(name = "家长关系2",combo = {"父亲","母亲","爷爷","奶奶","叔叔","姑姑"},readConverterExp = "0=父亲,1=母亲,2=爷爷,3=奶奶,4=叔叔,5=姑姑")
    private String relationship2;

    /**
     * 家长工作单位2
     */
    @Excel(name = "家长工作单位2", width = 30)
    private String workAddress2;

    /**
     * 家长联系地址2
     */
    @Excel(name = "家长联系地址2", width = 30)
    private String contactAddress2;

    /**
     * 家长联系电话2
     */
    @Excel(name = "家长联系电话2")
    private String telephone2;

    /**
     * 家长邮政编码2
     */
    @Excel(name = "家长邮政编码2")
    private String postalCode2;


}
