package yangtz.cs.liu.campus.domain.schoolEquipment;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.util.Date;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.core.domain.OurBaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

/**
 * 设备报修对象 school_equipment_repair
 *
 * @author ruoyi
 * @date 2023-08-09
 */
@Data
public class SchoolEquipmentRepair extends OurBaseEntity
{

    /** 设备id */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /** 设备id */
    private Long equipmentId;

    /** 分类编码 */
    private String classificationCode;

    /** 报修时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date reportRepairTime;

    /** 报修人id */
    private Long reportRepairId;

    /** 报修人 */
    private String reportRepair;

    /** 问题 */
    private String problem;

    /** 修理人id */
    private Long repairId;

    /** 修理人 */
    private String repairName;

    /** 修理人联系方式 */
    private Long repairPhone;

    /** 修理时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date repairTime;

    /** 修理状态（0已维修，1已损坏） */
    private String repairState;

    /** 处理状态（1已处理，0待处理） */
    private String disposeState;

    /** 评价（1一星，2二星，3三星，4四星，5五星） */
    private Long evaluate;

    /** 备注 */
    private String remark;
}
