package yangtz.cs.liu.campus.domain.schoolEquipment;

import com.ruoyi.common.annotation.Excel;
import java.util.Date;

import com.core.domain.OurBaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

/**
 * 设备借出归还对象 school_circulation
 *
 * @author ruoyi
 * @date 2023-08-09
 */
@Data
public class SchoolCirculation extends OurBaseEntity
{

    /** 设备id */
    private Long equipmentId;

    /** 借用日期 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date borrowTime;

    /** 借用人id */
    private Long borrowById;

    /** 借用人 */
    private String borrowBy;

    /** 用途 */
    private String purpose;

    /** 借用期限（天） */
    private Long deadline;

    /** 归还状态(0=未归还，1=已归还)" */
    private String returnState;

    /** 归还日期 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date returnTime;

    /** 归还时设备情况 */
    private String returnEquipmentCondition;

    /** 接收人id */
    private Long receivedById;

    /** 接收人 */
    private String receivedBy;

    /** 预计使用时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date yjuseTime;

    /** 实际使用时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date sjuseTime;

    /** 备注 */
    private String remark;
}
