package yangtz.cs.liu.campus.domain.schoolAssets;

import java.util.Date;

import com.core.domain.OurBaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;

import javax.validation.constraints.NotNull;

/**
 * 【请填写功能名称】对象 school_assets_out
 *
 * @author ruoyi
 * @date 2023-01-07
 */
@Data
public class SchoolAssetsOut extends OurBaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 资产id */
    @Excel(name = "资产id")
    @NotNull(message = "资产id不能为空")
    private Long assetsId;

    /** 出库数量 */
    @Excel(name = "出库数量")
    @NotNull(message = "出库数量不能为空")
    private Integer outNumbers;

    /** 出库日期 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "出库日期", width = 30, dateFormat = "yyyy-MM-dd")
    @NotNull(message = "出库日期不能为空")
    private Date outDate;

    /** 出库类型(0领用 1盘减 2报废 3捐赠 4损坏) */
    @Excel(name = "出库类型(0领用 1盘减 2报废 3捐赠 4损坏)")
    @NotNull(message = "出库类型不能为空")
    private String outType;

    /** 领用人 */
    @Excel(name = "领用人")
    @NotNull(message = "领用人不能为空")
    private Long outBy;

    /** remark */
    @Excel(name = "备注")
    private String remark;


}
