package yangtz.cs.liu.campus.domain.schoolAssets;

import java.util.Date;

import com.core.domain.OurBaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;

import javax.validation.constraints.NotNull;

/**
 * 【请填写功能名称】对象 school_assets_enter
 *
 * @author ruoyi
 * @date 2023-01-07
 */
@Data
public class SchoolAssetsEnter extends OurBaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 资产id */
    @Excel(name = "资产id")
    @NotNull(message = "资产id不能为空")
    private Long assetsId;

    /** 入库数量 */
    @Excel(name = "入库数量")
    @NotNull(message = "入库数量不能为空")
    private Integer enterNumbers;

    /** 入库日期 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @NotNull(message = "入库日期不能为空")
    @Excel(name = "入库日期", width = 30, dateFormat = "yyyy-MM-dd")
    private Date enterDate;

    /** 入库类型(0采购入库 1盘增) */
    @Excel(name = "入库类型(0采购入库 1盘增)")
    private String enterType;

    /** 入库人 */
    @Excel(name = "入库人")
    @NotNull(message = "入库人不能为空")
    private Long enterBy;

    /** remark */
    @Excel(name = "备注")
    private String remark;


}
