package yangtz.cs.liu.campus.domain.organization;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.core.domain.OurBaseEntity;
import lombok.Data;
import com.ruoyi.common.annotation.Excel;

/**
 * 社团报名审核对象 school_organization_signin
 * 
 * @author liul
 * @date 2023-09-06
 */
@Data
public class SchoolOrganizationSignin extends OurBaseEntity
{
    private static final long serialVersionUID = 1L;
    /** id */
    @Excel(name = "id")
    private Long id;
    /** 姓名 */
    @Excel(name = "姓名")
    private String name;

    /** 性别(1男 2女) */
    @Excel(name = "性别(1男 2女)")
    private String sex;

    /** 年级 */
    @Excel(name = "年级")
    private String grade;

    /** 班级 */
    @Excel(name = "班级")
    private String classes;

    /** 兴趣爱好 */
    @Excel(name = "兴趣爱好")
    private String hobby;

    /** 电话 */
    @Excel(name = "电话")
    private String phone;

    /** 申请理由 */
    @Excel(name = "申请理由")
    private String reason;

    /** 审核状态（1未审核 2同意 3不同意） */
    @Excel(name = "审核状态", readConverterExp = "1=未审核,2=同意,3=不同意")
    private String status;

    /** 社团id */
    @Excel(name = "社团id")
    private Long cid;

    /** 社团名称 */
    @Excel(name = "社团名称")
    private String orgName;

    /** userId */
    private Long userId;

    /** 身份证号 */
    private String cardid;

}
