package yangtz.cs.liu.campus.domain.message;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.core.domain.OurBaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.Date;

/**
 * 家长端消息推送对象 school_message_parents_pushs
 *
 * @author ruoyi
 * @date 2022-10-28
 */
@Data
public class SchoolMessageParentsPushs extends OurBaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 标题 */
    @Excel(name = "标题")
    @NotBlank(message = "标题不能为空")
    private String title;

    /** 消息类型 */
    @Excel(name = "消息类型",readConverterExp = "1=通知,2=公告")
    private String messageType;

    /** 状态 */
    @Excel(name = "状态", readConverterExp = "0=正常,1=停用")
    private String state;

    /** 内容 */
//    @Excel(name = "内容",width = 35)
    private String content;

    /** 创建者 */
    @TableField(fill = FieldFill.INSERT)
    @Excel(name = "创建者")
    private String createBy;

    /** 创建时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm")
    @TableField(fill = FieldFill.INSERT)
    @Excel(name = "创建时间",dateFormat = "yyyy-MM-dd HH:mm")
    private Date createTime;

}
