package yangtz.cs.liu.campus.domain.interest;

import com.core.domain.OurBaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;

import javax.validation.constraints.NotNull;
import java.util.Date;

/**
 * 兴趣班详情对象 school_interest_classes_details
 * 
 * @author ruoyi
 * @date 2022-10-04
 */
@Data
public class SchoolInterestClassesDetails extends OurBaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 兴趣班ID */
   // @NotNull(message = "兴趣班id不能为空")
    @Excel(name = "兴趣班ID")
    private Long interestClassesId;

    /** 课程开始时间 */
    @NotNull(message = "课程开始时间不能为空")
    @Excel(name = "课程开始时间", width = 30, dateFormat = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date courseStartTime;

    /** 课程结束时间 */
    @NotNull(message = "课程结束时间不能为空")
    @Excel(name = "课程结束时间", width = 30, dateFormat = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date courseEndTime;

    /** 班级别名 */
    @Excel(name = "班级别名")
    private String classAlias;

    /** 周 */
    @Excel(name = "周")
    private String week;

    /** 备注 */
    @Excel(name = "备注")
    private String remarks;
}
