package yangtz.cs.liu.campus.domain.curricula;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.core.domain.OurBaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.util.Date;

@Data
public class CurriculaStudent {
    /** 主键id */
    @TableId(value = "id",type = IdType.AUTO)
    private Long id;
    /** 学生主键id */
    private Long studentId;
    /** 选课任务主键id */
    private Long curriculaId;
    /** 课程类型（1-春季选课，2-夏季选课，3-艺体） */
    private String courseType;
    /** 选课时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date curriculaTime;
    /** 选课状态（1-未选课，2-已选课） */
    private String curriculaState;
    /** 已选课程 */
    private String selectedCourse;
    /** 已选专业 */
    private String selectedMajor;
    /** 所选科目 */
    private String selectedSubject;
    /** 是否删除 */
    private String delFlag;
}
