package yangtz.cs.liu.campus.controller.training;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.enums.BusinessType;
import yangtz.cs.liu.campus.domain.training.Training;
import yangtz.cs.liu.campus.service.training.ITrainingService;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.common.core.page.TableDataInfo;

/**
 * 培训情况Controller
 *
 * @author ruoyi
 * @date 2023-07-25
 */
@RestController
@RequestMapping("/training")
public class TrainingController extends BaseController
{
    @Autowired
    private ITrainingService trainingService;

    /**
     * 查询培训情况列表
     */
//    @PreAuthorize("@ss.hasPermi('training:training:list')")
    @GetMapping("/list")
    public TableDataInfo list(Training training)
    {
        startPage();
        List<Training> list = trainingService.selectTrainingList(training);
        return getDataTable(list);
    }

    /**
     * 导出培训情况列表
     */
//    @PreAuthorize("@ss.hasPermi('training:training:export')")
    @Log(title = "培训情况", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, Training training)
    {
        List<Training> list = trainingService.selectTrainingList(training);
        ExcelUtil<Training> util = new ExcelUtil<Training>(Training.class);
        util.exportExcel(response, list, "培训情况数据");
    }

    /**
     * 获取培训情况详细信息
     */
//    @PreAuthorize("@ss.hasPermi('training:training:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(trainingService.selectTrainingById(id));
    }

    /**
     * 新增培训情况
     */
//    @PreAuthorize("@ss.hasPermi('training:training:add')")
    @Log(title = "培训情况", businessType = BusinessType.INSERT)
    @PostMapping("/add")
    public AjaxResult add(@RequestBody Training training)
    {
        return toAjax(trainingService.insertTraining(training));
    }

    /**
     * 修改培训情况
     */
//    @PreAuthorize("@ss.hasPermi('training:training:edit')")
    @Log(title = "培训情况", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody Training training)
    {
        return toAjax(trainingService.updateTraining(training));
    }

    /**
     * 删除培训情况
     */
//    @PreAuthorize("@ss.hasPermi('training:training:remove')")
    @Log(title = "培训情况", businessType = BusinessType.DELETE)
    @DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(trainingService.deleteTrainingByIds(ids));
    }
}
