package yangtz.cs.liu.campus.controller.teacherFiles;

import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.utils.poi.ExcelUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;
import yangtz.cs.liu.campus.domain.teacherFiles.TeacherFiles;
import yangtz.cs.liu.campus.domain.teacherFiles.TeacherFilesNotice;
import yangtz.cs.liu.campus.service.teacherFiles.ITeacherFilesService;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 教师档案Controller
 * 
 * @author ruoyi
 * @date 2023-09-06
 */
@RestController
@RequestMapping("/teacherFiles/files")
public class TeacherFilesController extends BaseController
{
    @Autowired
    private ITeacherFilesService teacherFilesService;

    /**
     * 查询教师档案列表
     */
    @PreAuthorize("@ss.hasPermi('teacherFiles:files:list')")
    @GetMapping("/list")
    public TableDataInfo list(TeacherFiles teacherFiles)
    {
        startPage();
        List<TeacherFiles> list = teacherFilesService.selectTeacherFilesList(teacherFiles);
        return getDataTable(list);
    }

    /**
     * 老师查看自己的档案任务
     */
    @GetMapping("getTeachList/{userId}")
    public TableDataInfo teachList(@PathVariable("userId") Long userId){
        startPage();
        List<TeacherFilesNotice> teacherFilesNotices = teacherFilesService.selctTeacherByUserId(userId);
        return getDataTable(teacherFilesNotices);
    }


    /**
     * 导出教师档案列表
     */
    @PreAuthorize("@ss.hasPermi('teacherFiles:files:export')")
    @Log(title = "教师档案", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, TeacherFiles teacherFiles)
    {
        List<TeacherFiles> list = teacherFilesService.selectTeacherFilesList(teacherFiles);
        ExcelUtil<TeacherFiles> util = new ExcelUtil<TeacherFiles>(TeacherFiles.class);
        util.exportExcel(response, list, "教师档案数据");
    }

    /**
     * 获取教师档案详细信息
     */
    @PreAuthorize("@ss.hasPermi('teacherFiles:files:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(teacherFilesService.selectTeacherFilesById(id));
    }

    /**
     * 新增教师档案
     */
    @PreAuthorize("@ss.hasPermi('teacherFiles:files:add')")
    @Log(title = "教师档案", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TeacherFiles teacherFiles)
    {
        teacherFiles.setState("0");
        return toAjax(teacherFilesService.insertTeacherFiles(teacherFiles));
    }

    /**
     * 修改教师档案
     */
    @PreAuthorize("@ss.hasPermi('teacherFiles:files:edit')")
    @Log(title = "教师档案", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TeacherFiles teacherFiles)
    {
        return toAjax(teacherFilesService.updateTeacherFiles(teacherFiles));
    }

    /**
     * 删除教师档案
     */
    @PreAuthorize("@ss.hasPermi('teacherFiles:files:remove')")
    @Log(title = "教师档案", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(teacherFilesService.deleteTeacherFilesByIds(ids));
    }


    /**
     * 教师档案同步
     */
    @PreAuthorize("@ss.hasPermi('teacherFiles:files:edit')")
    @Log(title = "教师档案同步", businessType = BusinessType.UPDATE)
    @PutMapping("/synchronous/{id}")
    public AjaxResult synchronous(@PathVariable("id") Long id)
    {
        return toAjax(teacherFilesService.synchronous(id));
    }


    @PreAuthorize("@ss.hasPermi('teacherFiles:notice:edit')")
    @Log(title = "教师档案审核通过", businessType = BusinessType.UPDATE)
    @PutMapping("/passThrough/{id}")
    public AjaxResult passThrough(@PathVariable("id")  Long id)
    {
        TeacherFiles teacherFiles = new TeacherFiles();
        teacherFiles.setId(id);
        teacherFiles.setState("5");
        return toAjax(teacherFilesService.updateTeacherFiles(teacherFiles));
    }

    @PreAuthorize("@ss.hasPermi('teacherFiles:notice:edit')")
    @Log(title = "教师档案审核驳回", businessType = BusinessType.UPDATE)
    @PutMapping("/reject/{id}")
    public AjaxResult reject(@PathVariable("id")  Long id)
    {
        TeacherFiles teacherFiles = new TeacherFiles();
        teacherFiles.setId(id);
        teacherFiles.setState("9");
        return toAjax(teacherFilesService.updateTeacherFiles(teacherFiles));
    }

    @PreAuthorize("@ss.hasPermi('teacherFiles:notice:edit')")
    @Log(title = "教师档案提交", businessType = BusinessType.UPDATE)
    @PutMapping("/submitTo/{id}")
    public AjaxResult submitTo(@PathVariable("id")  Long id)
    {
        TeacherFiles teacherFiles = new TeacherFiles();
        teacherFiles.setId(id);
        teacherFiles.setState("4");
        return toAjax(teacherFilesService.updateTeacherFiles(teacherFiles));
    }

}
