package yangtz.cs.liu.campus.controller.teacher;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.common.utils.poi.ExcelUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import yangtz.cs.liu.campus.domain.teacher.SchoolTeacherResume;
import yangtz.cs.liu.campus.domain.teacher.SchoolTeacherWages;
import yangtz.cs.liu.campus.service.teacher.ISchoolTeacherWagesService;
import yangtz.cs.liu.campus.vo.student.SchoolStudentVO;
import yangtz.cs.liu.campus.vo.student.SchoolTeacherWagesVO;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 学校老师工资Controller
 *
 * @author ruoyi
 * @date 2022-09-27
 */
@RestController
@RequestMapping("/school/teacherWages")
public class SchoolTeacherWagesController extends BaseController {

    @Autowired
    private ISchoolTeacherWagesService schoolTeacherWagesService;

    /**
     * 老师工资列表
     *
     * @param schoolTeacherWages
     * @return
     */
    @GetMapping("/list")
    public TableDataInfo list(SchoolTeacherWages schoolTeacherWages) {
        startPage();
        List<SchoolTeacherWages> list = schoolTeacherWagesService.queryList(schoolTeacherWages);
        return getDataTable(list);
    }

    /**
     * 新增
     *
     * @param schoolTeacherWages
     * @return
     */
    @PostMapping("/add")
    public AjaxResult add(@RequestBody @Validated SchoolTeacherWages schoolTeacherWages) {
        return toAjax(schoolTeacherWagesService.save(schoolTeacherWages));
    }

    /**
     * 弹窗后新增
     * @param teacherId
     * @return
     */
    @PostMapping("/add/{teacherId}")
    public AjaxResult add(@PathVariable("teacherId") Long teacherId,@RequestBody @Validated SchoolTeacherWages schoolTeacherWages){
        return toAjax(schoolTeacherWagesService.insertByTeacherId(teacherId,schoolTeacherWages));
    }


    /**
     * 修改
     *
     * @param schoolTeacherWages
     * @return
     */
    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody @Validated SchoolTeacherWages schoolTeacherWages) {
        if (StringUtils.isNull(schoolTeacherWages.getId())) {
            return AjaxResult.error("老师工资id未传");
        }
        return toAjax(schoolTeacherWagesService.updateById(schoolTeacherWages));
    }

    /**
     * 查询详情
     *
     * @param id
     * @return
     */
    @GetMapping("/queryOne/{id}")
    public AjaxResult queryOne(@PathVariable("id") Integer id) {
        return AjaxResult.success(schoolTeacherWagesService.getById(id));
    }

    /**
     * 删除
     *
     * @param ids
     * @return
     */
    @DeleteMapping("/delete/{ids}")
    @Transactional(rollbackFor = Exception.class)
    public AjaxResult delete(@PathVariable("ids") List<Integer> ids) {
        return toAjax(schoolTeacherWagesService.removeByIds(ids));
    }

    /**
     * 导出
     *
     * @param ids
     * @return
     */
    @PostMapping("/export/{ids}")
    public void export(HttpServletResponse response, @PathVariable("ids") List<Integer> ids) {
        List<SchoolTeacherWages> list = schoolTeacherWagesService.listByIds(ids);
        ExcelUtil<SchoolTeacherWages> util = new ExcelUtil<>(SchoolTeacherWages.class);
        util.exportExcel(response, list, "教师履历");
    }

    //导出全部
    @PostMapping("/export")
    public void exportAll(HttpServletResponse response, SchoolTeacherWages schoolTeacherWages) {
//        LambdaQueryWrapper<SchoolTeacherWages> lqw = new LambdaQueryWrapper<>();
//        lqw
//                .orderByDesc(SchoolTeacherWages::getCreateTime)
//        ;
//        List<SchoolTeacherWages> list = schoolTeacherWagesService.list(lqw);
        List<SchoolTeacherWages> list = schoolTeacherWagesService.queryList(schoolTeacherWages);
        ExcelUtil<SchoolTeacherWages> util = new ExcelUtil<>(SchoolTeacherWages.class);
        util.exportExcel(response, list, "教师履历");
    }

    /*
     * 模板
     * */
    @PostMapping("/importTemplate")
    public void importTemplate(HttpServletResponse response) {
        ExcelUtil<SchoolTeacherWages> util = new ExcelUtil<SchoolTeacherWages>(SchoolTeacherWages.class);
        util.importTemplateExcel(response, "学校老师工资");
    }

//    /**
//     * 学生导入
//     */
//    @PostMapping("/importStudent")
//    public AjaxResult importData(MultipartFile file, boolean updateSupport) {
//        try {
//            ExcelUtil<SchoolTeacherWagesVO> util = new ExcelUtil<SchoolTeacherWagesVO>(SchoolTeacherWagesVO.class);
//            List<SchoolTeacherWagesVO> dataManagementList = util.importExcel(file.getInputStream());
//            String operName = getUsername();
//            String message = schoolTeacherWagesService.importStudent(dataManagementList, updateSupport, operName);
//            return AjaxResult.success(message);
//        } catch (Exception e) {
//            e.printStackTrace();
//        }
//        return AjaxResult.error();
//    }


    @PostMapping("/importData")
    public AjaxResult importData(MultipartFile file)throws Exception{
        ExcelUtil<SchoolTeacherWages> util = new ExcelUtil<>(SchoolTeacherWages.class);
        List<SchoolTeacherWages> list = util.importExcel(file.getInputStream());
        //校验
        schoolTeacherWagesService.checkData(list);
        String message = schoolTeacherWagesService.importData(list);
        return AjaxResult.success(message);
    }
}
