package yangtz.cs.liu.campus.controller.teacher;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.common.utils.poi.ExcelUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import yangtz.cs.liu.campus.domain.teacher.SchoolTeacherResume;
import yangtz.cs.liu.campus.service.teacher.ISchoolTeacherResumeService;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

import static com.baomidou.mybatisplus.core.toolkit.ObjectUtils.isNotNull;
import static com.baomidou.mybatisplus.core.toolkit.StringUtils.isNotBlank;

/**
 * 学校老师履历Controller
 *
 * @author ruoyi
 * @date 2022-09-27
 */
@RestController
@RequestMapping("/school/teacherResume")
public class SchoolTeacherResumeController extends BaseController {

    @Autowired
    private ISchoolTeacherResumeService schoolTeacherResumeService;

    /**
     * 老师履历列表
     *
     * @param schoolTeacherResume
     * @return
     */
    @GetMapping("/list")
    public TableDataInfo list(SchoolTeacherResume schoolTeacherResume) {
        startPage();
        List<SchoolTeacherResume> list = schoolTeacherResumeService.queryList(schoolTeacherResume);
        return getDataTable(list);
    }

    /**
     * 新增
     *
     * @param schoolTeacherResume
     * @return
     */
    @PostMapping("/add")
    public AjaxResult add(@RequestBody @Validated SchoolTeacherResume schoolTeacherResume) {
        return toAjax(schoolTeacherResumeService.save(schoolTeacherResume));
    }

    /**
     * 修改
     *
     * @param schoolTeacherResume
     * @return
     */
    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody @Validated SchoolTeacherResume schoolTeacherResume) {
        if (StringUtils.isNull(schoolTeacherResume.getId())){
            return AjaxResult.error("老师学历id未传");
        }
        return toAjax(schoolTeacherResumeService.updateById(schoolTeacherResume));
    }

    /**
     * 查询详情
     *
     * @param id
     * @return
     */
    @GetMapping("/queryOne/{id}")
    public AjaxResult queryOne(@PathVariable("id") Integer id) {
        return AjaxResult.success(schoolTeacherResumeService.getById(id));
    }

    /**
     * 删除
     *
     * @param ids
     * @return
     */
    @DeleteMapping("/delete/{ids}")
    @Transactional(rollbackFor = Exception.class)
    public AjaxResult delete(@PathVariable("ids") List<Integer> ids) {
        return toAjax(schoolTeacherResumeService.removeByIds(ids));
    }

    /**
     * 导出
     *
     * @param ids
     * @return
     */
    @PostMapping("/export/{ids}")
    public void export(HttpServletResponse response, @PathVariable("ids") List<Integer> ids) {
        List<SchoolTeacherResume> list = schoolTeacherResumeService.listByIds(ids);
        ExcelUtil<SchoolTeacherResume> util = new ExcelUtil<>(SchoolTeacherResume.class);
        util.exportExcel(response, list, "教师履历");
    }

    //导出全部
    @PostMapping("/export")
    public void exportAll(HttpServletResponse response, SchoolTeacherResume schoolTeacherResume) {
        LambdaQueryWrapper<SchoolTeacherResume> lqw = new LambdaQueryWrapper<>();
        lqw
                .orderByDesc(SchoolTeacherResume::getCreateTime)
        ;
        List<SchoolTeacherResume> list = schoolTeacherResumeService.list(lqw);
        ExcelUtil<SchoolTeacherResume> util = new ExcelUtil<>(SchoolTeacherResume.class);
        util.exportExcel(response, list, "教师履历");
    }
}
