package yangtz.cs.liu.campus.controller.teacher;

import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.exception.ServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import yangtz.cs.liu.campus.controller.patrol.SchoolPatrolController;
import yangtz.cs.liu.campus.service.teacher.ISchoolMentorService;
import yangtz.cs.liu.campus.vo.student.SchoolStudentParentVO;

import java.util.List;

@RestController
@RequestMapping("/school/mentor")
public class SchoolMentorController extends BaseController {
    private Logger log = LoggerFactory.getLogger(SchoolPatrolController.class);

    @Autowired
    private ISchoolMentorService schoolMentorService;

    /**
     * 查询学生家长 教师工作
     *
     * @param schoolStudentParentVO
     * @return
     */
    @GetMapping("/parentList")
    public TableDataInfo parentList(SchoolStudentParentVO schoolStudentParentVO) {
        try {
            startPage();
            List<SchoolStudentParentVO> list = schoolMentorService.selectParentList(schoolStudentParentVO,getUserId());
            return getDataTable(list);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            throw new ServiceException("查询学生家长异常");
        }
    }

}
