package yangtz.cs.liu.campus.controller.teacher;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.common.utils.StringUtils;
import lombok.extern.log4j.Log4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import yangtz.cs.liu.campus.controller.patrol.SchoolPatrolController;
import yangtz.cs.liu.campus.domain.SchoolStudentIntegral.SchoolStudentIntegral;
import yangtz.cs.liu.campus.domain.schoolClass.SchoolClass;
import yangtz.cs.liu.campus.domain.schoolgrade.SchoolGrade;
import yangtz.cs.liu.campus.service.ISchoolStudentIntegra.ISchoolStudentIntegralService;
import yangtz.cs.liu.campus.service.schoolClass.ISchoolClassService;
import yangtz.cs.liu.campus.service.schoolgrade.ISchoolGradeService;
import yangtz.cs.liu.campus.service.student.ISchoolStudentService;
import yangtz.cs.liu.campus.service.teacher.ISchoolHeadMasterService;
import yangtz.cs.liu.campus.vo.schoolgrade.GradeTreeSelect;
import yangtz.cs.liu.campus.vo.student.SchoolStudentParentVO;
import yangtz.cs.liu.campus.vo.student.SchoolStudentVO;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.stream.Collectors;

import static com.ruoyi.common.utils.StringUtils.isNotNull;
import static org.apache.commons.lang3.StringUtils.isNotBlank;

@RestController
@RequestMapping("/school/headMaster")
public class SchoolHeadMasterController extends BaseController {

    private Logger log = LoggerFactory.getLogger(SchoolPatrolController.class);

    @Autowired
    private ISchoolHeadMasterService schoolHeadMasterService;


    @Autowired
    private ISchoolClassService schoolClassService;

    @Autowired
    private ISchoolStudentService schoolStudentService;

    @Autowired
    private ISchoolStudentIntegralService integralService;

    /**
     * 查询班级列表 班主任
     *
     * @param schoolClass
     * @return
     */
    @GetMapping("/list")
    public TableDataInfo list(SchoolClass schoolClass) {
        try {
            startPage();
            schoolClass.setTeacherId(getUserId());
            List<SchoolClass> list = schoolClassService.selectSchoolClassList(schoolClass);
            return getDataTable(list);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            throw new ServiceException("班级管理列表异常");
        }
    }

    /**
     * 查询学生家长 班主任
     *
     * @param schoolStudentParentVO
     * @return
     */
    @GetMapping("/parentList")
    public TableDataInfo parentList(SchoolStudentParentVO schoolStudentParentVO) {
        try {
            startPage();
            List<SchoolStudentParentVO> list = schoolHeadMasterService.selectParentList(schoolStudentParentVO,getUserId());
            return getDataTable(list);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            throw new ServiceException("查询学生家长异常");
        }
    }

    /**班主任-学生管理*/
    @GetMapping("/getStudentList")
    public TableDataInfo studentList(SchoolStudentVO schoolStudent) {
        //获取班级列表
        SchoolClass schoolClass = new SchoolClass();
        if(StringUtils.isNotNull(schoolStudent.getSchoolYear())){
            schoolClass.setSchoolYear(schoolStudent.getSchoolYear());
        }
        LambdaQueryWrapper<SchoolClass> lqw = new LambdaQueryWrapper<>();
        lqw.eq(SchoolClass::getTeacherId,getUserId())
                .eq(isNotNull(schoolClass.getSchoolYear()),SchoolClass::getSchoolYear,schoolClass.getSchoolYear());
        List<SchoolClass> schoolClassList = schoolClassService.list(lqw);
        if(StringUtils.isNull(schoolClassList) || schoolClassList.size() == 0){
            return getDataTable(new ArrayList<>());
        }
        //获取班级id并排重
        List<Long> classIdList = schoolClassList.stream().map(SchoolClass::getId).distinct().collect(Collectors.toList());

        startPage();
        List<SchoolStudentVO> list = schoolStudentService.getGradeStudent(classIdList,schoolStudent);

        //获取当前所处学期
        int term = isNewTerm();
        for(SchoolStudentVO vo : list){
            SchoolStudentIntegral i = new SchoolStudentIntegral();
            i.setTerm(term);
            i.setSchoolYear(schoolStudent.getSchoolYear());
            i.setStudentId(vo.getId());
            List<SchoolStudentIntegral> integrals = integralService.selectSchoolStudentIntegralList(i);
            if(StringUtils.isNotNull(integrals) && integrals.size() > 0){
                double sum = integralService.countScore(integrals);
                vo.setScore(sum);
            }else {
                vo.setScore(100.0);
            }
        }
        return getDataTable(list);
    }

    private Integer isNewTerm() {
        Calendar cal = Calendar.getInstance();
        //获取当前年月
        int nowYear = cal.get(Calendar.YEAR);
        int month = cal.get(Calendar.MONTH) + 1;
        //设置当前学期为上学期
        int term = 0;
        //2-7为下学期，8-1为上学期
        if (month >= 2 && month < 8) {
            term = 1;
        }
        return term;
    }

}
