package yangtz.cs.liu.campus.controller.student;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.domain.entity.SysUser;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.system.mapper.SysUserMapper;
import com.ruoyi.system.service.ISysUserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import yangtz.cs.liu.campus.domain.student.SchoolStudentParent;
import yangtz.cs.liu.campus.service.schoolClass.ISchoolClassService;
import yangtz.cs.liu.campus.service.student.ISchoolStudentParentService;
import yangtz.cs.liu.campus.vo.student.SchoolStudentParentVO;

import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

import static yangtz.cs.liu.campus.constant.UserType.PARENT;

/**
 * 学校学生父母信息Controller
 *
 * @author ruoyi
 * @date 2022-09-27
 */
@RestController
@RequestMapping("/school/studentParent")
public class SchoolStudentParentController extends BaseController {

    @Autowired
    private ISchoolStudentParentService schoolStudentParentService;
    @Autowired
    private ISchoolClassService classService;

    @Autowired
    private SysUserMapper userMapper;

    /**
     * 学生父母信息列表
     *
     * @param schoolStudentParent
     * @return
     */
    @GetMapping("/list/{studentId}")
    public TableDataInfo list(@PathVariable("studentId") Long studentId, SchoolStudentParent schoolStudentParent) {
        startPage();
        schoolStudentParent.setStudentId(studentId);
        List<SchoolStudentParent> list = schoolStudentParentService.queryList(schoolStudentParent);
        return getDataTable(list);
    }

    /**
     * 新增
     *
     * @param schoolStudentParent
     * @return
     */
    @PostMapping("/add/{studentId}")
    public AjaxResult add(@PathVariable("studentId") Long studentId, @RequestBody @Validated SchoolStudentParent schoolStudentParent) {
        return toAjax(schoolStudentParentService.addParent(studentId, schoolStudentParent));
    }

    /**
     * 修改
     *
     * @param schoolStudentParent
     * @return
     */
    @PutMapping("/edit/{studentId}")
    public AjaxResult edit(@PathVariable("studentId") Long studentId, @RequestBody @Validated SchoolStudentParent schoolStudentParent) {
        if (StringUtils.isNull(schoolStudentParent.getId()) || StringUtils.isNull(schoolStudentParent.getUserId())) {
            AjaxResult.error("父母信息id未传");
        }
        return toAjax(schoolStudentParentService.updateParent(studentId,schoolStudentParent));
    }

    /**
     * 查询详情
     *
     * @param id
     * @return
     */
    @GetMapping("/queryOne/{id}")
    public AjaxResult queryOne(@PathVariable("id") Long id) {
        return AjaxResult.success(schoolStudentParentService.getById(id));
    }


    /**
     *
     * @param ids
     * @return
     */
    @DeleteMapping("/delete/{ids}")
    @Transactional(rollbackFor = Exception.class)
    public AjaxResult delete(@PathVariable("ids") List<Long> ids) {

        /** 删除用户表 */
        LambdaQueryWrapper<SchoolStudentParent> parentLqw = new LambdaQueryWrapper<>();
        parentLqw.select(SchoolStudentParent::getUserId).in(SchoolStudentParent::getId, ids);
        List<Long> list = schoolStudentParentService.list(parentLqw).stream().map(SchoolStudentParent::getUserId).collect(Collectors.toList());
        userMapper.deleteUserByIds(list.toArray(new Long[list.size()]));

        /** 删除家长表 */
        LambdaQueryWrapper<SchoolStudentParent> lqw = new LambdaQueryWrapper<>();
        lqw.in(SchoolStudentParent::getId, ids);
        return toAjax(schoolStudentParentService.remove(lqw));
    }

    /**
     * 导出
     *
     * @param ids
     * @return
     */
    @PostMapping("/export/{ids}")
    public void export(HttpServletResponse response, @PathVariable("ids") List<Long> ids) {
        List<SchoolStudentParent> list = schoolStudentParentService.listByIds(ids);
        ExcelUtil<SchoolStudentParent> util = new ExcelUtil<>(SchoolStudentParent.class);
        util.exportExcel(response, list, "学生父母信息");
    }

    //导出全部
    @PostMapping("/export")
    public void exportAll(HttpServletResponse response, SchoolStudentParent schoolStudentParent) {
        LambdaQueryWrapper<SchoolStudentParent> lqw = new LambdaQueryWrapper<>();
        lqw
                .orderByDesc(SchoolStudentParent::getCreateTime)
        ;
        List<SchoolStudentParent> list = schoolStudentParentService.list(lqw);
        ExcelUtil<SchoolStudentParent> util = new ExcelUtil<>(SchoolStudentParent.class);
        util.exportExcel(response, list, "学生父母信息");
    }

//    //全部家长信息
    @GetMapping("/allParent")
    public TableDataInfo AllParent(SchoolStudentParentVO schoolStudentParentVO) {
        startPage();
        List<SchoolStudentParentVO> list = schoolStudentParentService.selectAllParent(schoolStudentParentVO);
        return getDataTable(list);
    }

    /**教师工作-家长信息，教师所带班级学生的家长*/
    @GetMapping("/teacherParent")
    public TableDataInfo teacherParent(SchoolStudentParentVO schoolStudentParentVO) {
        //获取教师所在最新学年的班级列表
        List<Long> classIds = classService.getTeacherClasses(getUserId());
        if(StringUtils.isNull(classIds) || classIds.size() == 0){
            return getDataTable(new ArrayList<>());
        }
        startPage();
        List<SchoolStudentParentVO> list = schoolStudentParentService.selectTeacherParent(classIds,schoolStudentParentVO);
        return getDataTable(list);
    }
}
