package yangtz.cs.liu.campus.controller.student;


import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.common.utils.poi.ExcelUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import yangtz.cs.liu.campus.domain.student.SchoolStudentEvaluate;
import yangtz.cs.liu.campus.service.student.ISchoolStudentEvaluateService;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 学生综合素质评价Controller
 *
 * @author ruoyi
 * @date 2022-09-27
 */
@RestController
@RequestMapping("/school/studentEvaluate")
public class SchoolStudentEvaluateController extends BaseController {
    @Autowired
    private ISchoolStudentEvaluateService schoolStudentEvaluateService;

    /**
     * 学生综合素质评价列表
     *
     * @param schoolStudentEvaluate
     * @return
     */
    @GetMapping("/list")
    public TableDataInfo list(SchoolStudentEvaluate schoolStudentEvaluate) {
        startPage();
        List<SchoolStudentEvaluate> list = schoolStudentEvaluateService.queryList(schoolStudentEvaluate);
        return getDataTable(list);
    }

    /**
     * 新增
     *
     * @param schoolStudentEvaluate
     * @return
     */
    @PostMapping("/add")
    public AjaxResult add(@RequestBody @Validated SchoolStudentEvaluate schoolStudentEvaluate) {
        return toAjax(schoolStudentEvaluateService.save(schoolStudentEvaluate));
    }

    /**
     * 修改
     *
     * @param schoolStudentEvaluate
     * @return
     */
    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody @Validated SchoolStudentEvaluate schoolStudentEvaluate) {
        if(StringUtils.isNull(schoolStudentEvaluate.getId())){
            AjaxResult.error("素质评价id未传");
        }
        return toAjax(schoolStudentEvaluateService.updateById(schoolStudentEvaluate));
    }

    /**
     * 查询详情
     *
     * @param id
     * @return
     */
    @GetMapping("/queryOne/{id}")
    public AjaxResult queryOne(@PathVariable("id") Integer id) {
        return AjaxResult.success(schoolStudentEvaluateService.getById(id));
    }

    /**
     * 删除
     *
     * @param ids
     * @return
     */
    @DeleteMapping("/delete/{ids}")
    @Transactional(rollbackFor = Exception.class)
    public AjaxResult delete(@PathVariable("ids") List<Integer> ids) {
        return toAjax(schoolStudentEvaluateService.removeByIds(ids));
    }

    /**
     * 导出
     *
     * @param ids
     * @return
     */
    @PostMapping("/export/{ids}")
    public void export(HttpServletResponse response, @PathVariable("ids") List<Integer> ids) {
        List<SchoolStudentEvaluate> list = schoolStudentEvaluateService.listByIds(ids);
        ExcelUtil<SchoolStudentEvaluate> util = new ExcelUtil<>(SchoolStudentEvaluate.class);
        util.exportExcel(response, list, "学生综合素质评价");
    }

    //导出全部
    @PostMapping("/export")
    public void exportAll(HttpServletResponse response, SchoolStudentEvaluate schoolStudentEvaluate) {
        LambdaQueryWrapper<SchoolStudentEvaluate> lqw = new LambdaQueryWrapper<>();
        lqw
                .orderByDesc(SchoolStudentEvaluate::getCreateTime)
        ;
        List<SchoolStudentEvaluate> list = schoolStudentEvaluateService.list(lqw);
        ExcelUtil<SchoolStudentEvaluate> util = new ExcelUtil<>(SchoolStudentEvaluate.class);
        util.exportExcel(response, list, "学生综合素质评价");
    }

}