package yangtz.cs.liu.campus.controller.student;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.common.utils.poi.ExcelUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import yangtz.cs.liu.campus.domain.student.SchoolEducationRuleDetails;
import yangtz.cs.liu.campus.domain.student.SchoolStudentEvaluate;
import yangtz.cs.liu.campus.service.student.ISchoolEducationRuleDetailsService;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 学校德育检查打分明细Controller
 *
 * @author ruoyi
 * @date 2022-09-27
 */
@RestController
@RequestMapping("/school/educationRuleDetails")
public class SchoolEducationRuleDetailsController extends BaseController {

    @Autowired
    private ISchoolEducationRuleDetailsService iSchoolEducationRuleDetailsService;

    /**
     * 学校德育检查打分明细列表 列表
     *
     * @param schoolEducationRuleDetails
     * @return
     */
    @GetMapping("/list")
    public TableDataInfo list(SchoolEducationRuleDetails schoolEducationRuleDetails) {
        startPage();
        List<SchoolEducationRuleDetails> list = iSchoolEducationRuleDetailsService.queryList(schoolEducationRuleDetails);
        return getDataTable(list);
    }

    /**
     * 新增
     *
     * @param schoolEducationRuleDetails
     * @return
     */
    @PostMapping("/add/{ruleId}")
    public AjaxResult add(@RequestBody @Validated SchoolEducationRuleDetails schoolEducationRuleDetails) {
        return toAjax(iSchoolEducationRuleDetailsService.save(schoolEducationRuleDetails));
    }

    /**
     * 修改
     *
     * @param schoolEducationRuleDetails
     * @return
     */
    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody @Validated SchoolEducationRuleDetails schoolEducationRuleDetails) {
        if(StringUtils.isNull(schoolEducationRuleDetails.getId())){
            return AjaxResult.error("德育规则详情id未传");
        }
        return toAjax(iSchoolEducationRuleDetailsService.updateById(schoolEducationRuleDetails));
    }

    /**
     * 查询详情
     *
     * @param id
     * @return
     */
    @GetMapping("/queryOne/{id}")
    public AjaxResult queryOne(@PathVariable("id") Long id) {
        return AjaxResult.success(iSchoolEducationRuleDetailsService.getById(id));
    }

    /**
     * 删除
     *
     * @param ids
     * @return
     */
    @DeleteMapping("/delete/{ids}")
    @Transactional(rollbackFor = Exception.class)
    public AjaxResult delete(@PathVariable("ids") List<Long> ids) {
        return toAjax(iSchoolEducationRuleDetailsService.removeByIds(ids));
    }

    /**
     * 导出
     *
     * @param ids
     * @return
     */
    @PostMapping("/export/{ids}")
    public void export(HttpServletResponse response, @PathVariable("ids") List<Long> ids) {
        List<SchoolEducationRuleDetails> list = iSchoolEducationRuleDetailsService.listByIds(ids);
        ExcelUtil<SchoolEducationRuleDetails> util = new ExcelUtil<>(SchoolEducationRuleDetails.class);
        util.exportExcel(response, list, "学校德育检查打分明细");
    }

    //导出全部
    @PostMapping("/export")
    public void exportAll(HttpServletResponse response, SchoolEducationRuleDetails schoolEducationRuleDetails) {
        List<SchoolEducationRuleDetails> list = iSchoolEducationRuleDetailsService.queryList(schoolEducationRuleDetails);
        ExcelUtil<SchoolEducationRuleDetails> util = new ExcelUtil<>(SchoolEducationRuleDetails.class);
        util.exportExcel(response, list, "学校德育检查打分明细");
    }

    /**
     *  TODO 德育检查打分明细导入
     */
}
