package yangtz.cs.liu.campus.controller.student;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.common.utils.poi.ExcelUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import yangtz.cs.liu.campus.domain.student.SchoolEducationRule;
import yangtz.cs.liu.campus.domain.student.SchoolEducationRuleDetails;
import yangtz.cs.liu.campus.domain.student.SchoolStudentEvaluate;
import yangtz.cs.liu.campus.domain.student.SchoolStudentParent;
import yangtz.cs.liu.campus.service.student.ISchoolEducationRuleDetailsService;
import yangtz.cs.liu.campus.service.student.ISchoolEducationRuleService;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 学校德育检查打分规则Controller
 *
 * @author ruoyi
 * @date 2022-09-27
 */
@RestController
@RequestMapping("/school/educationRule")
public class SchoolEducationRuleController extends BaseController {

    @Autowired
    private ISchoolEducationRuleService schoolEducationRuleService;

    @Autowired
    private ISchoolEducationRuleDetailsService schoolEducationRuleDetailsService;

    /**
     * 学校德育检查打分规则 列表
     *
     * @param schoolEducationRule
     * @return
     */
    @GetMapping("/list")
    public TableDataInfo list(SchoolEducationRule schoolEducationRule) {
        startPage();
        List<SchoolEducationRule> list = schoolEducationRuleService.queryList(schoolEducationRule);
        return getDataTable(list);
    }

    /**
     * 新增
     *
     * @param schoolEducationRule
     * @return
     */
    @PostMapping("/add")
    public AjaxResult add(@RequestBody @Validated SchoolEducationRule schoolEducationRule) {
        return toAjax(schoolEducationRuleService.save(schoolEducationRule));
    }

    /**
     * 修改
     *
     * @param schoolEducationRule
     * @return
     */
    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody @Validated SchoolEducationRule schoolEducationRule) {
        if(StringUtils.isNull(schoolEducationRule.getId())){
            return AjaxResult.error("德育规则id未传");
        }
        return toAjax(schoolEducationRuleService.updateById(schoolEducationRule));
    }

    /**
     * 查询详情
     *
     * @param id
     * @return
     */
    @GetMapping("/queryOne/{id}")
    public AjaxResult queryOne(@PathVariable("id") Long id) {
        return AjaxResult.success(schoolEducationRuleService.getById(id));
    }

    /**
     * 删除
     *
     * @param ids
     * @return
     */
    @DeleteMapping("/delete/{ids}")
    @Transactional(rollbackFor = Exception.class)
    public AjaxResult delete(@PathVariable("ids") List<Long> ids) {
        LambdaQueryWrapper<SchoolEducationRuleDetails> lqw = new LambdaQueryWrapper<>();
        lqw
                .in(SchoolEducationRuleDetails::getRuleId, ids)
        ;
        schoolEducationRuleDetailsService.remove(lqw);
        return toAjax(schoolEducationRuleService.removeByIds(ids));
    }

    /**
     * 导出
     *
     * @param ids
     * @return
     */
    @PostMapping("/export/{ids}")
    public void export(HttpServletResponse response, @PathVariable("ids") List<Long> ids) {
        List<SchoolEducationRule> list = schoolEducationRuleService.listByIds(ids);
        ExcelUtil<SchoolEducationRule> util = new ExcelUtil<>(SchoolEducationRule.class);
        util.exportExcel(response, list, "学校德育检查打分规则");
    }

    //导出全部
    @PostMapping("/export")
    public void exportAll(HttpServletResponse response, SchoolEducationRule schoolEducationRule) {
        List<SchoolEducationRule> list = schoolEducationRuleService.queryList(schoolEducationRule);
        ExcelUtil<SchoolEducationRule> util = new ExcelUtil<>(SchoolEducationRule.class);
        util.exportExcel(response, list, "学校德育检查打分规则");
    }
}
