package yangtz.cs.liu.campus.controller.schooloffical;

import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.system.service.ISysUserService;
import org.apache.ibatis.annotations.Param;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import yangtz.cs.liu.campus.domain.schooloffical.SchoolOfficial;
import yangtz.cs.liu.campus.domain.schooloffical.SchoolOfficialFlow;
import yangtz.cs.liu.campus.service.pubFile.IPubFileService;
import yangtz.cs.liu.campus.service.schooloffical.ISchoolOfficalService;
import yangtz.cs.liu.campus.service.schooloffical.ISchoolOfficialFlowService;
import yangtz.cs.liu.campus.vo.schoolOfficial.SchoolOfficialFlowVo;
import yangtz.cs.liu.campus.vo.schoolOfficial.SchoolOfficialVo;
import yangtz.cs.liu.campus.vo.schooloffical.UserIdVo;
import yangtz.cs.liu.wechat.service.api.IWxApiService;

import java.util.List;

import static yangtz.cs.liu.campus.constant.OfficalConstant.*;

@RestController
@RequestMapping("/schoolofficialflow")
public class SchoolOfficialFlowController extends BaseController {
    @Autowired
    private ISchoolOfficialFlowService flowService;

    @Autowired
    private ISchoolOfficalService schoolOfficalService;

    /**
     * 首页>我的任务公文流转>任务(任务状态为流转中)
     * state,区分是我的任务还是历史任务
     */
    @GetMapping("/taskList/{state}")
    public TableDataInfo myTaskList(@PathVariable String state, SchoolOfficial schoolOffical) {
        Long userId = getUserId();
        startPage();
        List<SchoolOfficialVo> list = schoolOfficalService.myTaskList(userId, state, schoolOffical);
        return getDataTable(list);
    }

    /**
     * 详情页
     * 分为两块，一块是公文详情，一块是该公文已被哪些人办理,
     */
    @GetMapping("/review/getInfo/{id}")
    public AjaxResult reviewGetInfo(@PathVariable Long id) {
        AjaxResult ajax = AjaxResult.success();
        SchoolOfficialVo offical = schoolOfficalService.getInfo(id);
        List<SchoolOfficialFlowVo> list = flowService.getReviewList(id);
        ajax.put("offical", offical);
        ajax.put("review", list);
        return ajax;

    }

    /**
     * 批阅人操作
     * 需传个批阅意见
     *
     * @return
     */
    @PutMapping("/review/{id}")
    public AjaxResult review(@PathVariable Long id, String opinion) {
        if (StringUtils.isEmpty(opinion)) {
            throw new ServiceException("请输入批阅意见");
        }
        //设置查询条件
        SchoolOfficialFlow flow = new SchoolOfficialFlow();
        //主表id
        flow.setOfficialId(id);
        //当前批阅人id
        flow.setReceiveUser(getUserId());
        //批阅人类型
        flow.setReceiveType(REVIEWER);
        //状态（未完成）
        flow.setState(UNDONE);
        //意见
        flow.setOpinion(opinion);
        return toAjax(flowService.review(flow));

    }

    /**
     * 发起人操作
     * id主键id
     * 批阅人单选传userId
     * 传阅接收人，多选传userIds
     * 二者只传一个
     *
     * @return
     */
    @PutMapping("/initiator/{id}")
    public AjaxResult initiator(@PathVariable Long id, @RequestBody UserIdVo vo) {
        if (StringUtils.isNotNull(vo.getUserId()) && vo.getUserIds().length != 0) {
            throw new ServiceException("批阅人和传阅人两者只能传一个");
        }
        if (StringUtils.isNull(vo.getUserId()) && vo.getUserIds().length == 0) {
            throw new ServiceException("批阅人和传阅人两者必须传一个");
        }
        return toAjax(flowService.chooseReview(id, vo.getUserId(), vo.getUserIds()));
    }

    /**
     * 传阅人操作
     * id主键id
     * 在传阅人第一次查看公文，点进去页面，或者关闭页面时发送请求，将当前传阅人状态改为已完成
     * 并判断该公文对应的所有传阅人状态是否都是已完成，若都已完成，则将该公文状态改为已完结
     *
     * @return
     */
    @PutMapping("/circulator/{id}")
    public AjaxResult initiator(@PathVariable Long id) {
        //修改当前传阅人状态
        int num = flowService.editState(id, getUserId(), CIRCULATOR);
        //判断所有传阅人状态是否，都已完成
        schoolOfficalService.judgeState(id);
        return toAjax(num);
    }

}
