package yangtz.cs.liu.campus.controller.schoolexam;



import javax.servlet.http.HttpServletResponse;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.common.utils.poi.ExcelUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import org.springframework.web.multipart.MultipartFile;
import yangtz.cs.liu.campus.domain.schoolClass.SchoolClass;
import yangtz.cs.liu.campus.domain.schoolexam.SchoolExam;
import yangtz.cs.liu.campus.domain.schoolexam.SchoolExamDetail;
import yangtz.cs.liu.campus.domain.schoolgrade.SchoolGrade;
import yangtz.cs.liu.campus.service.schoolClass.ISchoolClassService;
import yangtz.cs.liu.campus.service.schoolexam.ISchoolExamDetailService;
import yangtz.cs.liu.campus.service.schoolexam.ISchoolExamService;
import yangtz.cs.liu.campus.service.schoolgrade.ISchoolGradeService;
import yangtz.cs.liu.campus.service.student.ISchoolStudentClassesService;
import java.util.List;

import static com.baomidou.mybatisplus.core.toolkit.StringUtils.isNotBlank;

/**
 * 学校考试信息Controller
 *
 * @author ruoyi
 * @date 2022-09-29
 */
@RestController
@RequestMapping("/schoolExam")
public class SchoolExamController extends BaseController {

    @Autowired
    private ISchoolExamService schoolExamService;
    @Autowired
    private ISchoolExamDetailService schoolExamDetailService;
    @Autowired
    private ISchoolClassService schoolClassService;

    private Logger log = LoggerFactory.getLogger(SchoolExamController.class);


    /**
     * 查询
     *
     * @param schoolExam
     * @return
     */
    @GetMapping("/list")
    public TableDataInfo list(SchoolExam schoolExam) {
        try {
            startPage();
            List<SchoolExam> list = schoolExamService.queryList(schoolExam);
            return getDataTable(list);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            throw new ServiceException("出现未知错误");
        }
    }

    /**
     * 年级查询
     * @return
     */
    @GetMapping("/gradeList")
    public TableDataInfo gradeList(SchoolClass schoolClass){
        try{
            List<SchoolClass> list = schoolClassService.selectSchoolClassList(schoolClass);
            return getDataTable(list);
        } catch (Exception e){
            log.error(e.getMessage(),e);
            throw new ServiceException("出现未知错误");
        }
    }

    /**
     * 导出
     *
     * @param response
     * @param ids
     */
    @PostMapping("/export/{ids}")
    public void export(HttpServletResponse response, @PathVariable("ids") List<Long> ids) {
        List<SchoolExam> list = schoolExamService.listByIds(ids);
        ExcelUtil<SchoolExam> util = new ExcelUtil<>(SchoolExam.class);
        util.exportExcel(response, list, "学校考试表");
    }

    /**
     * 导出全部
     *
     * @param response
     * @param schoolExam
     */
    @PostMapping("/export")
    public void exportAll(HttpServletResponse response, SchoolExam schoolExam) {
        List<SchoolExam> list = schoolExamService.queryList(schoolExam);
        ExcelUtil<SchoolExam> util = new ExcelUtil<>(SchoolExam.class);
        util.exportExcel(response, list, "学校考试表");
    }


    /**
     * 新增
     *
     * @param schoolExam
     * @return
     */
    @PostMapping("/add")
    public AjaxResult add(@RequestBody @Validated SchoolExam schoolExam) {
        return toAjax(schoolExamService.saveNew(schoolExam));
    }

    /**
     * 修改学校考试信息
     *
     * @param schoolExam
     * @return
     */
    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody @Validated SchoolExam schoolExam) {
        if (StringUtils.isNull(schoolExam.getId())) {
            throw new ServiceException("主键为空");
        }
        return toAjax(schoolExamService.updateByIdNew(schoolExam));
    }

    /**
     * 查询详细
     *
     * @param id
     * @return
     */
    @GetMapping("/queryOne/{id}")
    public AjaxResult queryOne(@PathVariable("id") Long id) {
        return AjaxResult.success(schoolExamService.getById(id));
    }


    /**
     * 删除
     *
     * @param ids
     * @return
     */
    @DeleteMapping("/remove/{ids}")
    @Transactional(rollbackFor = Exception.class)
    public AjaxResult remove(@PathVariable("ids") List<Long> ids) {
        LambdaQueryWrapper<SchoolExamDetail> lqw = new LambdaQueryWrapper<>();
        lqw.in(SchoolExamDetail::getExamId, ids);
        schoolExamDetailService.remove(lqw);
        return toAjax(schoolExamService.removeByIds(ids));
    }

    /**
     * 下载模板
     *
     * @return
     */
    @PostMapping("/importTemplate")
    public void importTemplate(HttpServletResponse response) {
        ExcelUtil<SchoolExam> util = new ExcelUtil<>(SchoolExam.class);
        util.importTemplateExcel(response, "考试表");
    }

    /**
     * 导入
     *
     * @param file
     * @return
     * @throws Exception
     */
    @PostMapping("/importData")
    public AjaxResult importData(MultipartFile file) throws Exception {
        ExcelUtil<SchoolExam> util = new ExcelUtil<SchoolExam>(SchoolExam.class);
        List<SchoolExam> list = util.importExcel(file.getInputStream());
        //校验
        schoolExamService.check(list);
        //导入
        String message = schoolExamService.importExamDetail(list);
        return AjaxResult.success(message);
    }



}
