package yangtz.cs.liu.campus.controller.schoolXxfb;

import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.common.utils.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;
import yangtz.cs.liu.campus.domain.schoolXxfb.SchoolXxfbRy;
import yangtz.cs.liu.campus.service.schoolXxfb.ISchoolXxfbRyService;

import java.util.List;

@RestController
@RequestMapping("/xxfb/ry")
public class SchoolXxfbRyController extends BaseController {
    @Autowired
    private ISchoolXxfbRyService ryService;
    /**
     * 获取信息发布内容详细信息
     */
    @PreAuthorize("@ss.hasPermi('system:ry:query')")
    @GetMapping(value = "/getInfo/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(ryService.getById(id));
    }

    /**
     * 新增信息发布内容
     * xxfbId 主表id
     */
    @PostMapping("/add/{xxfbId}")
    public AjaxResult add(@PathVariable Long xxfbId,@RequestBody SchoolXxfbRy schoolXxfbRy)
    {
        schoolXxfbRy.setXxfbId(xxfbId);
        return toAjax(ryService.save(schoolXxfbRy));
    }

    /**
     * 修改信息发布内容
     */
    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody SchoolXxfbRy schoolXxfbRy)
    {
        if(StringUtils.isNull(schoolXxfbRy.getId())){
            throw new ServiceException("信息发布内容id为空，请检查");
        }
        return toAjax(ryService.updateById(schoolXxfbRy));
    }

    /**
     * 删除信息发布内容
     */
    @DeleteMapping("/delete/{ids}")
    public AjaxResult remove(@PathVariable List<Long> ids)
    {
        return toAjax(ryService.removeByIds(ids));
    }
}
