package yangtz.cs.liu.campus.controller.schoolLab;

import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.utils.poi.ExcelUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import yangtz.cs.liu.campus.domain.schoolLab.SchoolLab;
import yangtz.cs.liu.campus.service.schoolLab.ISchoolLabService;
import yangtz.cs.liu.campus.vo.schoolLab.SchoolLabVo;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 实验室Controller
 *
 * @author ruoyi
 * @date 2023-08-29
 */
@RestController
@RequestMapping("/schoolLab")
public class SchoolLabController extends BaseController
{

    @Autowired
    private ISchoolLabService schoolLabService;

    /**
     * 查询实验室列表
     */
    @GetMapping("/list")
    public TableDataInfo list(SchoolLabVo schoolLabVo)
    {
        startPage();
        List<SchoolLabVo> list = schoolLabService.selectSchoolLabList(schoolLabVo,null);
        return getDataTable(list);
    }

    /**
     * 导出实验室列表
     */
    @Log(title = "实验室", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, SchoolLabVo schoolLabVo)
    {
        List<SchoolLabVo> list = schoolLabService.selectSchoolLabList(schoolLabVo,null);
        ExcelUtil<SchoolLabVo> util = new ExcelUtil<SchoolLabVo>(SchoolLabVo.class);
        util.exportExcel(response, list, "实验室数据");
    }

    /**
     * 获取实验室详细信息
     */
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(schoolLabService.selectSchoolLabById(id));
    }

    /**
     * 新增实验室
     */
    @Log(title = "实验室", businessType = BusinessType.INSERT)
    @PostMapping("/add")
    public AjaxResult add(@RequestBody SchoolLab schoolLab)
    {
        return toAjax(schoolLabService.insertSchoolLab(schoolLab));
    }

    /**
     * 修改实验室
     */
    @Log(title = "实验室", businessType = BusinessType.UPDATE)
    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody SchoolLab schoolLab)
    {
        return toAjax(schoolLabService.updateSchoolLab(schoolLab));
    }

    /**
     * 删除实验室
     */
    @Log(title = "实验室", businessType = BusinessType.DELETE)
    @PostMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(schoolLabService.deleteSchoolLabByIds(ids));
    }

    /**
     * 获取实验室负责人下拉框
     * @return
     */
    @GetMapping("/getLabAdmin")
    public AjaxResult getLabAdmin(){
        return AjaxResult.success(schoolLabService.getLabAdmin());
    }

    /**
     * 实验室管理员-获取学科下拉框
     * @return
     */
    @GetMapping("/getSub")
    public AjaxResult getSub(){
        return AjaxResult.success(schoolLabService.getSub());
    }
}
