package yangtz.cs.liu.campus.controller.schoolLab;

import java.util.List;
import javax.servlet.http.HttpServletResponse;

import com.ruoyi.common.core.domain.entity.SysUser;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.enums.BusinessType;
import yangtz.cs.liu.campus.domain.schoolLab.SchoolLabCompetition;
import yangtz.cs.liu.campus.service.schoolLab.ISchoolLabCompetitionService;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.common.core.page.TableDataInfo;
import yangtz.cs.liu.campus.vo.schoolLab.SchoolLabCompetitionVo;

/**
 * 实验室竞赛Controller
 *
 * @author ruoyi
 * @date 2023-08-29
 */
@RestController
@RequestMapping("/schoolLabCompetition")
public class SchoolLabCompetitionController extends BaseController
{
    @Autowired
    private ISchoolLabCompetitionService schoolLabCompetitionService;

    /**
     * 查询实验室竞赛列表
     */
    @GetMapping("/list")
    public TableDataInfo list(SchoolLabCompetitionVo schoolLabCompetitionVo)
    {
        startPage();
        List<SchoolLabCompetitionVo> list = schoolLabCompetitionService.selectSchoolLabCompetitionList(schoolLabCompetitionVo);
        return getDataTable(list);
    }

    /**
     * 导出实验室竞赛列表
     */
    @Log(title = "实验室竞赛", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, SchoolLabCompetitionVo schoolLabCompetitionVo)
    {
        List<SchoolLabCompetitionVo> list = schoolLabCompetitionService.selectSchoolLabCompetitionList(schoolLabCompetitionVo);
        ExcelUtil<SchoolLabCompetitionVo> util = new ExcelUtil<SchoolLabCompetitionVo>(SchoolLabCompetitionVo.class);
        util.exportExcel(response, list, "实验室竞赛数据");
    }

    /**
     * 获取实验室竞赛详细信息
     */
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(schoolLabCompetitionService.selectSchoolLabCompetitionById(id));
    }

    /**
     * 新增实验室竞赛
     */
    @Log(title = "实验室竞赛", businessType = BusinessType.INSERT)
    @PostMapping("/add")
    public AjaxResult add(@RequestBody SchoolLabCompetitionVo schoolLabCompetitionVo)
    {
        return toAjax(schoolLabCompetitionService.insertSchoolLabCompetition(schoolLabCompetitionVo));
    }

    /**
     * 修改实验室竞赛
     */
    @Log(title = "实验室竞赛", businessType = BusinessType.UPDATE)
    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody SchoolLabCompetitionVo schoolLabCompetitionVo)
    {
        return toAjax(schoolLabCompetitionService.updateSchoolLabCompetition(schoolLabCompetitionVo));
    }

    /**
     * 删除实验室竞赛
     */
    @Log(title = "实验室竞赛", businessType = BusinessType.DELETE)
    @PostMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(schoolLabCompetitionService.deleteSchoolLabCompetitionByIds(ids));
    }

    /**
     * 获取教师
     */
    @GetMapping("/getTeacher")
    public AjaxResult getTeacher(SysUser sysUser){
        return AjaxResult.success(schoolLabCompetitionService.getTeacher(sysUser));
    }
}
