package yangtz.cs.liu.campus.controller.schoolInstrument;

import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.utils.poi.ExcelUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import yangtz.cs.liu.campus.domain.schoolInstrument.SchoolInstrumentClassify;
import yangtz.cs.liu.campus.service.schoolInstrument.ISchoolInstrumentClassifyService;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 仪器药品分类Controller
 *
 * @author ruoyi
 * @date 2023-09-06
 */
@RestController
@RequestMapping("/schoolInstrumentClassify")
public class SchoolInstrumentClassifyController extends BaseController {
    @Autowired
    private ISchoolInstrumentClassifyService schoolInstrumentClassifyService;

    /**
     * 查询仪器药品分类列表
     */
    @GetMapping("/list")
    public TableDataInfo list(SchoolInstrumentClassify schoolInstrumentClassify)
    {
        List<SchoolInstrumentClassify> list = schoolInstrumentClassifyService.selectSchoolInstrumentClassifyList(schoolInstrumentClassify);
        return getDataTable(list);
    }

    /**
     * 获取仪器药品分类详细信息
     */
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(schoolInstrumentClassifyService.selectSchoolInstrumentClassifyById(id));
    }

    /**
     * 新增仪器药品分类
     */
    @Log(title = "仪器药品分类", businessType = BusinessType.INSERT)
    @PostMapping("/add")
    public AjaxResult add(@RequestBody SchoolInstrumentClassify schoolInstrumentClassify)
    {
        return toAjax(schoolInstrumentClassifyService.insertSchoolInstrumentClassify(schoolInstrumentClassify));
    }

    /**
     * 修改仪器药品分类
     */
    @Log(title = "仪器药品分类", businessType = BusinessType.UPDATE)
    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody SchoolInstrumentClassify schoolInstrumentClassify)
    {
        return toAjax(schoolInstrumentClassifyService.updateSchoolInstrumentClassify(schoolInstrumentClassify));
    }

    /**
     * 删除仪器药品分类
     */
    @Log(title = "仪器药品分类", businessType = BusinessType.DELETE)
    @PostMapping("/{id}")
    public AjaxResult remove(@PathVariable("id") Long id)
    {
        return toAjax(schoolInstrumentClassifyService.deleteSchoolInstrumentClassifyById(id));
    }
}
