package yangtz.cs.liu.campus.controller.schoolDepartmentBudget;

import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.utils.poi.ExcelUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import yangtz.cs.liu.campus.domain.schoolDepartmentBudget.SchoolDepartmentBudgetProjectmx;
import yangtz.cs.liu.campus.service.schoolDepartmentBudget.ISchoolDepartmentBudgetProjectmxService;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 科室预算填报项目明细Controller
 *
 * @author ruoyi
 * @date 2023-07-11
 */
@RestController
@RequestMapping("/departmentBudgetProjectmx")
public class SchoolDepartmentBudgetProjectmxController extends BaseController
{
    @Autowired
    private ISchoolDepartmentBudgetProjectmxService schoolDepartmentBudgetProjectmxService;

    /**
     * 查询科室预算填报项目明细列表
     */
//    @PreAuthorize("@ss.hasPermi('departmentBudgetProjectmx:projectmx:list')")
    @GetMapping("/list")
    public TableDataInfo list(SchoolDepartmentBudgetProjectmx schoolDepartmentBudgetProjectmx)
    {
        startPage();
        List<SchoolDepartmentBudgetProjectmx> list = schoolDepartmentBudgetProjectmxService.selectList(schoolDepartmentBudgetProjectmx);
        return getDataTable(list);
    }

    /**
     * 导出科室预算填报项目明细列表
     */
//    @PreAuthorize("@ss.hasPermi('departmentBudgetProjectmx:projectmx:export')")
    @Log(title = "科室预算填报项目明细", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, SchoolDepartmentBudgetProjectmx schoolDepartmentBudgetProjectmx)
    {
        List<SchoolDepartmentBudgetProjectmx> list = schoolDepartmentBudgetProjectmxService.selectList(schoolDepartmentBudgetProjectmx);
        for (SchoolDepartmentBudgetProjectmx departmentBudgetProjectmx : list) {
            String isGovernmentPurchase = departmentBudgetProjectmx.getIsGovernmentPurchase();
            if (isGovernmentPurchase.equals("1")){
                departmentBudgetProjectmx.setIsGovernmentPurchase("是");
            }else {
                departmentBudgetProjectmx.setIsGovernmentPurchase("否");
            }
        }
        ExcelUtil<SchoolDepartmentBudgetProjectmx> util = new ExcelUtil<SchoolDepartmentBudgetProjectmx>(SchoolDepartmentBudgetProjectmx.class);
        util.exportExcel(response, list, "科室预算填报项目明细数据");
    }

    /**
     * 获取科室预算填报项目明细详细信息
     */
//    @PreAuthorize("@ss.hasPermi('departmentBudgetProjectmx:projectmx:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(schoolDepartmentBudgetProjectmxService.selectSchoolDepartmentBudgetProjectmxById(id));
    }
















//    /**
//     * 新增科室预算填报项目明细
//     */
////    @PreAuthorize("@ss.hasPermi('departmentBudgetProjectmx:projectmx:add')")
//    @Log(title = "科室预算填报项目明细", businessType = BusinessType.INSERT)
//    @PostMapping
//    public AjaxResult add(@RequestBody SchoolDepartmentBudgetProjectmx schoolDepartmentBudgetProjectmx)
//    {
//        return toAjax(schoolDepartmentBudgetProjectmxService.insertSchoolDepartmentBudgetProjectmx(schoolDepartmentBudgetProjectmx));
//    }
//
//    /**
//     * 修改科室预算填报项目明细
//     */
////    @PreAuthorize("@ss.hasPermi('departmentBudgetProjectmx:projectmx:edit')")
//    @Log(title = "科室预算填报项目明细", businessType = BusinessType.UPDATE)
//    @PutMapping
//    public AjaxResult edit(@RequestBody SchoolDepartmentBudgetProjectmx schoolDepartmentBudgetProjectmx)
//    {
//        return toAjax(schoolDepartmentBudgetProjectmxService.updateSchoolDepartmentBudgetProjectmx(schoolDepartmentBudgetProjectmx));
//    }
//
//    /**
//     * 删除科室预算填报项目明细
//     */
////    @PreAuthorize("@ss.hasPermi('departmentBudgetProjectmx:projectmx:remove')")
//    @Log(title = "科室预算填报项目明细", businessType = BusinessType.DELETE)
//    @DeleteMapping("/{ids}")
//    public AjaxResult remove(@PathVariable Long[] ids)
//    {
//        return toAjax(schoolDepartmentBudgetProjectmxService.deleteSchoolDepartmentBudgetProjectmxByIds(ids));
//    }
}
