package yangtz.cs.liu.campus.controller.schoolDcwj;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.common.core.page.TableDataInfo;
import yangtz.cs.liu.campus.service.schoolDcwj.ISchoolDcwjRyService;
import yangtz.cs.liu.campus.domain.schoolDcwj.SchoolDcwjRy;
/**
 * 接收人Controller
 * 
 * @author wengxiulin
 * @date 2023-03-01
 */
@RestController
@RequestMapping("/dcwjRy")
public class SchoolDcwjRyController extends BaseController
{
    @Autowired
    private ISchoolDcwjRyService schoolDcwjRyService;

    /**
     * 查询接收人列表
     */
    @GetMapping("/list")
    public TableDataInfo list(SchoolDcwjRy schoolDcwjRy)
    {
        startPage();
        List<SchoolDcwjRy> list = schoolDcwjRyService.selectSchoolDcwjRyList(schoolDcwjRy);
        return getDataTable(list);
    }

    /**
     * 导出接收人列表
     */
    @Log(title = "接收人", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, SchoolDcwjRy schoolDcwjRy)
    {
        List<SchoolDcwjRy> list = schoolDcwjRyService.selectSchoolDcwjRyList(schoolDcwjRy);
        ExcelUtil<SchoolDcwjRy> util = new ExcelUtil<SchoolDcwjRy>(SchoolDcwjRy.class);
        util.exportExcel(response, list, "接收人数据");
    }

    /**
     * 获取接收人详细信息
     */
    @GetMapping(value = "/queryById/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(schoolDcwjRyService.selectSchoolDcwjRyById(id));
    }

    /**
     * 新增接收人
     */
    @Log(title = "接收人", businessType = BusinessType.INSERT)
    @PostMapping("/add")
    public AjaxResult add(@RequestBody SchoolDcwjRy schoolDcwjRy)
    {
        schoolDcwjRy.insert();
        return toAjax(schoolDcwjRyService.insertSchoolDcwjRy(schoolDcwjRy));
    }

    /**
     * 修改接收人
     */
    @Log(title = "接收人", businessType = BusinessType.UPDATE)
    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody SchoolDcwjRy schoolDcwjRy)
    {
        return toAjax(schoolDcwjRyService.updateSchoolDcwjRy(schoolDcwjRy));
    }

    /**
     * 删除接收人
     */
    @Log(title = "接收人", businessType = BusinessType.DELETE)
	@DeleteMapping("/delete/{ids}")
    public AjaxResult remove(@PathVariable List<Long> ids)
    {
        return toAjax(schoolDcwjRyService.removeByIds(ids));
    }
}
