package yangtz.cs.liu.campus.controller.schoolAssetsClaim;

import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.domain.entity.SysUser;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.common.exception.base.BaseException;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.common.utils.SecurityUtils;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.system.service.ISysUserService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import com.ruoyi.common.core.controller.BaseController;
import yangtz.cs.liu.campus.controller.schoolClass.SchoolClassController;
import yangtz.cs.liu.campus.domain.schoolAssets.SchoolAssets;
import yangtz.cs.liu.campus.domain.schoolAssets.SchoolAssetsOut;
import yangtz.cs.liu.campus.domain.schoolAssetsClaim.SchoolAssetsClaim;
import yangtz.cs.liu.campus.service.schoolAssets.ISchoolAssetsOutService;
import yangtz.cs.liu.campus.service.schoolAssets.ISchoolAssetsService;
import yangtz.cs.liu.campus.service.schoolAssetsClaim.ISchoolAssetsClaimService;
import yangtz.cs.liu.campus.vo.schoolAssetsClaim.AssetsClaimListVo;
import yangtz.cs.liu.campus.vo.schoolAssetsClaim.ClaimVo;
import yangtz.cs.liu.campus.vo.schoolAssetsClaim.SchoolAssetsClaimVo;

import java.util.List;

/**
 * 【请填写功能名称】Controller
 *
 * @author ruoyi
 * @date 2023-01-07
 */
@RestController
@RequestMapping("/schoolAssetsClaim")
public class SchoolAssetsClaimController extends BaseController
{
    private Logger log = LoggerFactory.getLogger(SchoolClassController.class);
    @Autowired
    private ISchoolAssetsService schoolAssetsService;
    @Autowired
    private ISchoolAssetsClaimService schoolAssetsClaimService;
    @Autowired
    private ISchoolAssetsOutService schoolAssetsOutService;
    @Autowired
    private ISysUserService userService;

    /**
     * 新增物品领用
     */
    @PostMapping("/add")
    /*public AjaxResult add(@RequestBody @Validated List<SchoolAssetsClaim> claimList) {
        return toAjax(schoolAssetsClaimService.saveBatch(claimList));
    }*/
    public AjaxResult add(@RequestBody @Validated ClaimVo vo) {
        if(StringUtils.isNull(vo.getList()) || vo.getList().size() == 0){
            throw new ServiceException("数据不完整");
        }
        return toAjax(schoolAssetsClaimService.saveClaims(vo));
    }

    /**
     * 修改物品领用
     */
    @PostMapping("/edit")
    public AjaxResult edit(@RequestBody @Validated SchoolAssetsClaim schoolAssetsClaim) {
        if (StringUtils.isNull(schoolAssetsClaim.getId())) {
            throw new BaseException("修改主键id不能为空");
        }
        return toAjax(schoolAssetsClaimService.updateById(schoolAssetsClaim));
    }

    /**
     * id查询
     */
    @GetMapping("/queryInfo/{id}")
    public AjaxResult queryInfo(@PathVariable Long id) {
        AssetsClaimListVo vo = new AssetsClaimListVo();
        SchoolAssetsClaim claim = schoolAssetsClaimService.getById(id);
        BeanUtils.copyProperties(claim,vo);
        SysUser user = userService.selectUserById(claim.getCollectBy());
        if(StringUtils.isNotNull(user)){
            vo.setCollectByName(user.getUserName());
        }
        return AjaxResult.success(vo);
    }


//    /**
//     * 删除物品领用
//     */
//    @DeleteMapping("/delete/ids")
//    @Transactional(rollbackFor = Exception.class)
//    public AjaxResult delete(@PathVariable("id") Long id) {
//        return toAjax(schoolAssetsClaimService.removeById(id));
//    }

    /**
     * 提交物品领用
     */
    @PostMapping("/submit/{id}")
    @Transactional(rollbackFor = Exception.class)
    public AjaxResult submit(@PathVariable Long id) {
        SchoolAssetsClaim claim = schoolAssetsClaimService.getById(id);
        //判断当前领用数量是否小于库存数量，否则，不能提交
        SchoolAssets assets = schoolAssetsService.getById(claim.getAssetsId());
        if(assets.getAssetsNumbers() < claim.getAssetsNumbers()){
            throw new ServiceException("当前库存数量不足，无法提交");
        }
        SchoolAssetsOut schoolAssetsOut = new SchoolAssetsOut();
        schoolAssetsOut.setAssetsId(claim.getAssetsId());
        schoolAssetsOut.setOutNumbers(claim.getAssetsNumbers());
        schoolAssetsOut.setOutDate(DateUtils.getNowDate());
        schoolAssetsOut.setOutType("0");
        schoolAssetsOut.setOutBy(claim.getCollectBy());
        schoolAssetsOut.setRemark(claim.getRemark());
       schoolAssetsOutService.save(schoolAssetsOut);  //新增出库记录
        claim.setState("1");
        schoolAssetsClaimService.updateById(claim);
        //库存数量减少
        return toAjax(schoolAssetsService.reduceAssets(claim.getAssetsId(),claim.getAssetsNumbers()));
    }

    /**
     * 后勤管理-物品领用-查看领用记录
     */
    @GetMapping ("/list")
    public TableDataInfo list(SchoolAssetsClaimVo schoolAssetsClaimVo) {
        startPage();
        List<AssetsClaimListVo> list = schoolAssetsClaimService.queryList(schoolAssetsClaimVo);
        return getDataTable(list);
    }


    /**
     * 查看个人领用记录
     */
    @GetMapping("/queryMyClaim")
    public AjaxResult queryMyClaim(SchoolAssetsClaimVo schoolAssetsClaimVo) {
        Long userId = SecurityUtils.getLoginUser().getUserId();
        List<AssetsClaimListVo> list = schoolAssetsClaimService.queryMyClaimList(userId,schoolAssetsClaimVo);
        return AjaxResult.success(list);
    }

    /**
     * 查看部门领用记录
     */
    @GetMapping("/queryDeptClaim")
    public AjaxResult queryDeptClaim(SchoolAssetsClaimVo schoolAssetsClaimVo) {
        Long deptId = SecurityUtils.getLoginUser().getDeptId();
        List<AssetsClaimListVo> list = schoolAssetsClaimService.queryDeptClaimList(deptId,schoolAssetsClaimVo);
        return AjaxResult.success(list);
    }

    /**
     * 删除领用
     */
    @DeleteMapping("/deleteById/{id}")
    @Transactional(rollbackFor = Exception.class)
    public AjaxResult delete(@PathVariable("id") Long id) {
        try{
            SchoolAssetsClaim schoolAssetsClaim = schoolAssetsClaimService.getById(id);
            if(schoolAssetsClaim.getState().equals("0")){   //未提交
                return toAjax(schoolAssetsClaimService.removeById(id));
            }
            if(schoolAssetsClaim.getState().equals("1")){  //已提交
                return AjaxResult.success("禁止删除");
            }
        }catch (Exception e){
            throw new ServiceException("删除失败");
        }
        return AjaxResult.success();
    }


//    /**
//     * 查询【请填写功能名称】列表
//     */
//    @PreAuthorize("@ss.hasPermi('system:claim:list')")
//    @GetMapping("/list")
//    public TableDataInfo list(SchoolAssetsClaim schoolAssetsClaim)
//    {
//        startPage();
//        List<SchoolAssetsClaim> list = schoolAssetsClaimService.selectSchoolAssetsClaimList(schoolAssetsClaim);
//        return getDataTable(list);
//    }
//
//    /**
//     * 导出【请填写功能名称】列表
//     */
//    @PreAuthorize("@ss.hasPermi('system:claim:export')")
//    @Log(title = "【请填写功能名称】", businessType = BusinessType.EXPORT)
//    @PostMapping("/export")
//    public void export(HttpServletResponse response, SchoolAssetsClaim schoolAssetsClaim)
//    {
//        List<SchoolAssetsClaim> list = schoolAssetsClaimService.selectSchoolAssetsClaimList(schoolAssetsClaim);
//        ExcelUtil<SchoolAssetsClaim> util = new ExcelUtil<SchoolAssetsClaim>(SchoolAssetsClaim.class);
//        util.exportExcel(response, list, "【请填写功能名称】数据");
//    }
//
//    /**
//     * 获取【请填写功能名称】详细信息
//     */
//    @PreAuthorize("@ss.hasPermi('system:claim:query')")
//    @GetMapping(value = "/{id}")
//    public AjaxResult getInfo(@PathVariable("id") Long id)
//    {
//        return AjaxResult.success(schoolAssetsClaimService.selectSchoolAssetsClaimById(id));
//    }
//
//    /**
//     * 新增【请填写功能名称】
//     */
//    @PreAuthorize("@ss.hasPermi('system:claim:add')")
//    @Log(title = "【请填写功能名称】", businessType = BusinessType.INSERT)
//    @PostMapping
//    public AjaxResult add(@RequestBody SchoolAssetsClaim schoolAssetsClaim)
//    {
//        return toAjax(schoolAssetsClaimService.insertSchoolAssetsClaim(schoolAssetsClaim));
//    }
//
//    /**
//     * 修改【请填写功能名称】
//     */
//    @PreAuthorize("@ss.hasPermi('system:claim:edit')")
//    @Log(title = "【请填写功能名称】", businessType = BusinessType.UPDATE)
//    @PutMapping
//    public AjaxResult edit(@RequestBody SchoolAssetsClaim schoolAssetsClaim)
//    {
//        return toAjax(schoolAssetsClaimService.updateSchoolAssetsClaim(schoolAssetsClaim));
//    }
//
//    /**
//     * 删除【请填写功能名称】
//     */
//    @PreAuthorize("@ss.hasPermi('system:claim:remove')")
//    @Log(title = "【请填写功能名称】", businessType = BusinessType.DELETE)
//	@DeleteMapping("/{ids}")
//    public AjaxResult remove(@PathVariable Long[] ids)
//    {
//        return toAjax(schoolAssetsClaimService.deleteSchoolAssetsClaimByIds(ids));
//    }
}
