package yangtz.cs.liu.campus.controller.patrol;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.common.exception.base.BaseException;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.common.utils.poi.ExcelUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import yangtz.cs.liu.campus.domain.patrol.SchoolPatrolRuleDetails;
import yangtz.cs.liu.campus.service.patrol.ISchoolPatrolRuleDetailsService;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 规则细节controller
 */
@RestController
@RequestMapping("/schoolPatrolRuleDetails")
public class SchoolPatrolRuleDetailsController extends BaseController {
    @Autowired
    private ISchoolPatrolRuleDetailsService schoolPatrolRuleDetailsService;

    private Logger log = LoggerFactory.getLogger(SchoolPatrolRuleDetailsController.class);

    /**
     * 查询列表
     *
     * @param schoolPatrolRuleDetails
     * @return
     */
    @GetMapping("/list/{ruleId}")
    public TableDataInfo list(@PathVariable("ruleId") Long ruleId, SchoolPatrolRuleDetails schoolPatrolRuleDetails) {
        try {
            schoolPatrolRuleDetails.setRuleId(ruleId);
            startPage();
            List<SchoolPatrolRuleDetails> list = schoolPatrolRuleDetailsService.queryList(schoolPatrolRuleDetails);
            return getDataTable(list);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            throw new ServiceException("查询规则细节列表出现异常");
        }
    }


    /**
     * 新增
     *
     * @param schoolPatrolRuleDetails
     * @return
     */
    @PostMapping("/add/{ruleId}")
    public AjaxResult add(@PathVariable("ruleId") Long ruleId, @RequestBody @Validated SchoolPatrolRuleDetails schoolPatrolRuleDetails) {
        schoolPatrolRuleDetails.setRuleId(ruleId);
        return toAjax(schoolPatrolRuleDetailsService.save(schoolPatrolRuleDetails));
    }

    /**
     * 修改
     *
     * @param schoolPatrolRuleDetails
     * @return
     */
    @PutMapping("/edit/{ruleId}")
    public AjaxResult edit(@PathVariable("ruleId") Long ruleId, @RequestBody @Validated SchoolPatrolRuleDetails schoolPatrolRuleDetails) {
        schoolPatrolRuleDetails.setRuleId(ruleId);
        if (StringUtils.isNull(schoolPatrolRuleDetails.getId())) {
            throw new BaseException("修改主键id不能为空");
        }
        return toAjax(schoolPatrolRuleDetailsService.updateById(schoolPatrolRuleDetails));
    }


    /**
     * 删除
     *
     * @param ids
     * @return
     */
    @DeleteMapping("/delete/{ids}")
    @Transactional(rollbackFor = Exception.class)
    public AjaxResult delete(@PathVariable("ids") List<Integer> ids) {
        try {
            return toAjax(schoolPatrolRuleDetailsService.removeByIds(ids));
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            throw new ServiceException("删除时异常");
        }
    }

    /**
     * 导出
     *
     * @param ids
     * @return
     */
    @PostMapping("/export/{ids}")
    public void export(HttpServletResponse response, @PathVariable("ids") List<Integer> ids) {
        List<SchoolPatrolRuleDetails> list = schoolPatrolRuleDetailsService.listByIds(ids);
        ExcelUtil<SchoolPatrolRuleDetails> util = new ExcelUtil<>(SchoolPatrolRuleDetails.class);
        util.exportExcel(response, list, "课堂巡视打分明细表");
    }

    /**
     * 导出全部
     *
     * @param response
     * @param schoolPatrolRuleDetails
     */
    @PostMapping("/export")
    public void export(HttpServletResponse response, SchoolPatrolRuleDetails schoolPatrolRuleDetails) {
        LambdaQueryWrapper<SchoolPatrolRuleDetails> lqw = new LambdaQueryWrapper<>();
        lqw.orderByAsc(SchoolPatrolRuleDetails::getSort);
        List<SchoolPatrolRuleDetails> list = schoolPatrolRuleDetailsService.list(lqw);
        ExcelUtil<SchoolPatrolRuleDetails> util = new ExcelUtil<>(SchoolPatrolRuleDetails.class);
        util.exportExcel(response, list, "课堂巡视打分明细表");
    }


}
