package yangtz.cs.liu.campus.controller.organization;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ruoyi.common.utils.SecurityUtils;
import com.ruoyi.common.utils.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.core.page.TableDataInfo;
import yangtz.cs.liu.campus.domain.organization.SchoolOrganizationInfo;
import yangtz.cs.liu.campus.domain.organization.SchoolOrganizationMember;
import yangtz.cs.liu.campus.domain.student.SchoolStudentParent;
import yangtz.cs.liu.campus.service.organization.ISchoolOrganizationMemberService;
import yangtz.cs.liu.campus.service.student.ISchoolStudentParentService;
import yangtz.cs.liu.campus.vo.organization.MemberListVo;

import java.util.Arrays;
import java.util.List;

/**
 * 社团成员Controller
 * 
 * @author liul
 * @date 2023-09-06
 */
@RestController
@RequestMapping("/member")
public class SchoolOrganizationMemberController extends BaseController
{
    @Autowired
    private ISchoolOrganizationMemberService schoolOrganizationMemberService;

    @Autowired
    private ISchoolStudentParentService schoolStudentParentService;

    /**
     * 查询社团成员列表
     */
    @GetMapping("/list")
    public TableDataInfo list(MemberListVo vo)
    {
        LambdaQueryWrapper<SchoolOrganizationMember> wrapper = Wrappers.lambdaQuery();
        wrapper.like(StringUtils.isNotEmpty(vo.getName()),SchoolOrganizationMember::getName,vo.getName())
                .eq(SchoolOrganizationMember::getCid,vo.getCid())
                .eq(StringUtils.isNotEmpty(vo.getClasses()),SchoolOrganizationMember::getClasses,vo.getClasses())
                .eq(StringUtils.isNotEmpty(vo.getGrade()),SchoolOrganizationMember::getGrade,vo.getGrade())
                .orderByDesc(SchoolOrganizationMember::getCreateTime);
        startPage();
        List<SchoolOrganizationMember> list = schoolOrganizationMemberService.list(wrapper);
        return getDataTable(list);
    }

    /**
     * 获取社团成员详细信息
     */
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(schoolOrganizationMemberService.getById(id));
    }

    /**
     * 新增社团成员
     */
    @Log(title = "社团成员", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SchoolOrganizationMember schoolOrganizationMember)
    {
        //新增社团成员的时候 要根据身份证号查询这个学生对应的userid
        LambdaQueryWrapper<SchoolStudentParent> wrapper = Wrappers.lambdaQuery();
        wrapper.eq(SchoolStudentParent::getIdCard,schoolOrganizationMember.getCardid());
        SchoolStudentParent one = schoolStudentParentService.getOne(wrapper);
        schoolOrganizationMember.setUserId(one.getUserId());
        return toAjax(schoolOrganizationMemberService.save(schoolOrganizationMember));
    }

    /**
     * 修改社团成员
     */
    @Log(title = "社团成员", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SchoolOrganizationMember schoolOrganizationMember)
    {
        return toAjax(schoolOrganizationMemberService.updateById(schoolOrganizationMember));
    }

    /**
     * 删除社团成员
     */
    @Log(title = "社团成员", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        List<Long> list = Arrays.asList(ids);
        return toAjax(schoolOrganizationMemberService.removeByIds(list));
    }
}
