package yangtz.cs.liu.campus.controller.organization;

import java.util.Arrays;
import java.util.List;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ruoyi.common.core.domain.entity.SysRole;
import com.ruoyi.common.core.domain.entity.SysUser;
import com.ruoyi.common.utils.SecurityUtils;
import com.ruoyi.common.utils.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.core.page.TableDataInfo;
import yangtz.cs.liu.campus.domain.organization.SchoolOrganizationFc;
import yangtz.cs.liu.campus.domain.organization.SchoolOrganizationInfo;
import yangtz.cs.liu.campus.domain.organization.SchoolOrganizationMember;
import yangtz.cs.liu.campus.service.organization.ISchoolOrganizationInfoService;
import yangtz.cs.liu.campus.service.organization.ISchoolOrganizationMemberService;

/**
 * 社团信息Controller
 * 
 * @author liul
 * @date 2023-09-06
 */
@RestController
@RequestMapping("/info")
public class SchoolOrganizationInfoController extends BaseController {
    @Autowired
    private ISchoolOrganizationInfoService schoolOrganizationInfoService;

    @Autowired
    private ISchoolOrganizationMemberService schoolOrganizationMemberService;

    /**
     * 查询社团信息列表
     */
    @GetMapping("/list")
    public TableDataInfo list(SchoolOrganizationInfo schoolOrganizationInfo)
    {
        List<SysRole> roles = SecurityUtils.getLoginUser().getUser().getRoles();
        SysUser user = SecurityUtils.getLoginUser().getUser();
        LambdaQueryWrapper<SchoolOrganizationInfo> wrapper = Wrappers.lambdaQuery();
        for (SysRole role : roles) {
            if (role.getRoleKey().equals("organization_manager")){
                //说明当前人是社团管理员 则只查看自己负责的社团
                wrapper.like(SchoolOrganizationInfo::getTeachersId,user.getUserId());
            }
        }
        wrapper.like(StringUtils.isNotEmpty(schoolOrganizationInfo.getName()),SchoolOrganizationInfo::getName,schoolOrganizationInfo.getName())
                .like(StringUtils.isNotEmpty(schoolOrganizationInfo.getTeachers()),SchoolOrganizationInfo::getTeachers,schoolOrganizationInfo.getTeachers())
                .orderByDesc(SchoolOrganizationInfo::getCreateTime);
        startPage();
        List<SchoolOrganizationInfo> list = schoolOrganizationInfoService.list(wrapper);
        if (list!=null && list.size()>0){
            for (int i = 0; i < list.size(); i++) {
                //查询该社团下面有多少人
                LambdaQueryWrapper<SchoolOrganizationMember> wrapper2 = Wrappers.lambdaQuery();
                wrapper2.eq(SchoolOrganizationMember::getCid,list.get(i).getId())
                        .eq(SchoolOrganizationMember::getDelFlag,"0");
                list.get(i).setNum(schoolOrganizationMemberService.count(wrapper2)+"");
            }
        }
        return getDataTable(list);
    }

    /**
     * 获取社团信息详细信息
     */
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(schoolOrganizationInfoService.getById(id));
    }

    /**
     * 新增社团信息
     */
    @Log(title = "社团信息", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SchoolOrganizationInfo schoolOrganizationInfo)
    {
        return toAjax(schoolOrganizationInfoService.save(schoolOrganizationInfo));
    }

    /**
     * 修改社团信息
     */
    @Log(title = "社团信息", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SchoolOrganizationInfo schoolOrganizationInfo)
    {
        return toAjax(schoolOrganizationInfoService.updateById(schoolOrganizationInfo));
    }

    /**
     * 删除社团信息
     */
    @Log(title = "社团信息", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        List<Long> list = Arrays.asList(ids);
        return toAjax(schoolOrganizationInfoService.removeByIds(list));
    }
}
