package yangtz.cs.liu.campus.controller.message;

import java.util.List;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import yangtz.cs.liu.campus.domain.message.SchoolMessagePushDetails;
import yangtz.cs.liu.campus.service.message.ISchoolMessagePushDetailsService;
import yangtz.cs.liu.campus.vo.message.PushDetailsVO;

/**
 * 消息推送详情Controller
 *
 * @author ruoyi
 * @date 2022-10-28
 */
@RestController
@RequestMapping("/schoolMessagePushDetails")
public class SchoolMessagePushDetailsController extends BaseController {
    @Autowired
    private ISchoolMessagePushDetailsService schoolMessagePushDetailsService;

    /**
     * 查询消息推送详情列表
     */
    @GetMapping("/list/{pushId}")
    public TableDataInfo list(@PathVariable Long pushId, PushDetailsVO pushDetailsVO) {
        startPage();
        pushDetailsVO.setPushId(pushId);
        List<PushDetailsVO> list = schoolMessagePushDetailsService.queryList(pushDetailsVO);
        return getDataTable(list);
    }

    /**
     * 弹窗，选择要推送给的用户列表
     */
    @GetMapping("/teacherList/{pushId}")
    public TableDataInfo teacherList(@PathVariable Long pushId, PushDetailsVO pushDetailsVO) {
        startPage();
        pushDetailsVO.setPushId(pushId);
        List<PushDetailsVO> list = schoolMessagePushDetailsService.queryAddList(pushDetailsVO);
        return getDataTable(list);
    }

    /**
     * 新增,挂载到当前的消息通知下
     */
    @PostMapping("/add/{pushId}/{userIds}")
    public AjaxResult add(@PathVariable Long pushId, @PathVariable List<Long> userIds) {
        return toAjax(schoolMessagePushDetailsService.addPushDetails(pushId, userIds));
    }

    /**
     * 删除选中
     */
    @DeleteMapping("/delete/{pushId}/{ids}")
    public AjaxResult delete(@PathVariable Long pushId, @PathVariable List<Long> ids) {
        LambdaQueryWrapper<SchoolMessagePushDetails> lqw = new LambdaQueryWrapper<>();
        lqw
                .eq(SchoolMessagePushDetails::getPushId, pushId)
                .in(SchoolMessagePushDetails::getId, ids)
        ;
        return toAjax(schoolMessagePushDetailsService.remove(lqw));
    }
}
