package yangtz.cs.liu.campus.controller.interest;

import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletResponse;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.common.utils.poi.ExcelUtil;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.core.page.TableDataInfo;
import org.springframework.web.multipart.MultipartFile;
import yangtz.cs.liu.campus.domain.interest.SchoolInterestClassesChild;
import yangtz.cs.liu.campus.domain.interest.SchoolInterestClassesDetails;
import yangtz.cs.liu.campus.domain.student.SchoolStudent;
import yangtz.cs.liu.campus.service.interest.ISchoolInterestClassesChildService;
import yangtz.cs.liu.campus.vo.interest.ChildVO;
import yangtz.cs.liu.campus.vo.interest.StudentVO;

/**
 * 兴趣班学生Controller
 *
 * @author ruoyi
 * @date 2022-10-09
 */
@RestController
@RequestMapping("/interestChild")
public class SchoolInterestClassesChildController extends BaseController
{
    @Autowired
    private ISchoolInterestClassesChildService schoolInterestClassesChildService;
    private Logger log = LoggerFactory.getLogger(SchoolInterestClassesChildController.class);
    /**
     * 查询兴趣班学生列表
     */
    @GetMapping("/list/{interestClassesId}")
    public TableDataInfo list(SchoolInterestClassesChild schoolInterestClassesChild,@PathVariable Long interestClassesId)
    {
        try {
            startPage();
            List<ChildVO> list = schoolInterestClassesChildService.queryList(schoolInterestClassesChild,interestClassesId);
            return getDataTable(list);
        }catch (Exception e){
            log.error(e.getMessage(),e);
            return getDataTable(null);
        }
    }

    /**
     * 新增兴趣班学生弹窗
     */
    @GetMapping("/addList/{interestClassesId}")
    public TableDataInfo addList(SchoolStudent student,@PathVariable Long interestClassesId) {
        try {
            //查询出该兴趣班下所有学生id
            List<Long> studentIdList = schoolInterestClassesChildService.selectAllStudentIdByInterestClassesId(interestClassesId);
            startPage();
            //查询出未参加该兴趣班的学生
            List<SchoolStudent> studentList = schoolInterestClassesChildService.selectAddList(student, studentIdList);
            return getDataTable(studentList);
        } catch (Exception e) {
            log.error(e.getMessage(),e);
            return getDataTable(null);
        }
    }


    /**
     * 导出兴趣班学生列表
     */
    @PreAuthorize("@ss.hasPermi('system:child:export')")
    @Log(title = "兴趣班学生", businessType = BusinessType.EXPORT)
    @PostMapping("/exportAll/{interestClassesId}")
    public void export(HttpServletResponse response,@PathVariable Long interestClassesId, SchoolInterestClassesChild schoolInterestClassesChild)
    {
        List<ChildVO> list = schoolInterestClassesChildService.queryList(schoolInterestClassesChild,interestClassesId);
        ExcelUtil<ChildVO> util = new ExcelUtil<ChildVO>(ChildVO.class);
        util.exportExcel(response, list, "兴趣班学生数据");
    }

    /**
     * 选中行导出
     *
     * @param ids
     * @return
     */
    @PostMapping("/export/{ids}")
    public void export(HttpServletResponse response, @PathVariable("ids") List<Integer> ids) {
        List<SchoolInterestClassesChild> list = schoolInterestClassesChildService.listByIds(ids);
        ExcelUtil<SchoolInterestClassesChild> util = new ExcelUtil<>(SchoolInterestClassesChild.class);
        util.exportExcel(response, list, "兴趣班学生数据");
    }

    /**
     * 获取兴趣班学生详细信息
     */
    @GetMapping(value = "/getInfo/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(schoolInterestClassesChildService.getById(id));
    }

    /**
     * 新增兴趣班学生，挂载到兴趣班下
     */
    @PostMapping("/add/{interestClassesId}")
    public AjaxResult add(@PathVariable Long interestClassesId, @RequestBody List<Long> idList)
    {
        return toAjax(schoolInterestClassesChildService.addStudents(interestClassesId,idList));
    }

    /**
     * 修改兴趣班学生(涉及的表太多了，可以先不加修改)
     */
    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody SchoolInterestClassesChild schoolInterestClassesChild)
    {
        if (StringUtils.isNull(schoolInterestClassesChild.getId())) {
            throw new ServiceException("id为空，修改失败");
        }
        return toAjax(schoolInterestClassesChildService.updateById(schoolInterestClassesChild));
    }

    /**
     * 删除兴趣班学生
     */
	@DeleteMapping("/delete/{ids}")
    public AjaxResult remove(@PathVariable List<Long> ids)
    {
        return toAjax(schoolInterestClassesChildService.removeByIds(ids));
    }

    /**
    模板
     */
    @PostMapping("/importTemplate")
    public void importTemplate(HttpServletResponse response) {
        ExcelUtil<StudentVO> util = new ExcelUtil<StudentVO>(StudentVO.class);
        util.importTemplateExcel(response, "学生数据");
    }

    /**
     学生导入
     */
    @PostMapping("/importData/{interestClassesId}")
    public AjaxResult importData(@PathVariable Long interestClassesId, MultipartFile file){
       try {
           ExcelUtil<StudentVO> util = new ExcelUtil<>(StudentVO.class);
           List<StudentVO> studentList = util.importExcel(file.getInputStream());
           String message = schoolInterestClassesChildService.importStudent(studentList, interestClassesId);
           return AjaxResult.success(message);
       }catch (Exception e){
           e.printStackTrace();
       }
       return AjaxResult.error();
    }
}
