package yangtz.cs.liu.campus.controller.examination;

import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.common.utils.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import yangtz.cs.liu.campus.constant.ArtExamConstant;
import yangtz.cs.liu.campus.domain.examination.SchoolArtExam;
import yangtz.cs.liu.campus.domain.examination.SchoolArtRelation;
import yangtz.cs.liu.campus.service.examination.ISchoolArtRelationService;

/**
 * @author xuten
 */
@RestController
@RequestMapping("/artRelation")
public class SchoolArtRelationController extends BaseController {
    @Autowired
    private ISchoolArtRelationService artRelationService;

    /**考场分配/成绩管理-查看*/
    @GetMapping("/getAddressInfo/{id}")
    public AjaxResult getAddressInfo(@PathVariable Long id) {
        return AjaxResult.success(artRelationService.getAddressInfo(id));
    }

    /**考场分配/成绩管理-修改*/
    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody SchoolArtRelation relation) {
        if (StringUtils.isNull(relation.getId())) {
            throw new ServiceException("id为空,请检查");
        }
        if (relation.getExamTime().contains("：")) {
            String t = relation.getExamTime();
            t = t.replace("：", ":");
            relation.setExamTime(t);
        }
        relation.update();
        return toAjax(artRelationService.updateById(relation));
    }


}
