package yangtz.cs.liu.campus.controller.exam;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.common.exception.base.BaseException;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.common.utils.poi.ExcelUtil;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import yangtz.cs.liu.campus.domain.exam.ExamDetail;
import yangtz.cs.liu.campus.domain.exam.ExamUser;
import yangtz.cs.liu.campus.domain.exam.ExamUserScore;
import yangtz.cs.liu.campus.domain.exam.ExamUserScoreDetail;
import yangtz.cs.liu.campus.service.exam.IExamUserScoreDetailService;
import yangtz.cs.liu.campus.service.exam.IExamUserScoreService;
import yangtz.cs.liu.campus.service.exam.IExamUserService;
import yangtz.cs.liu.campus.vo.exam.ExamUserVo;

import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;


/**
 * 问卷范围
 */
@RequestMapping("/examUser")
@RestController
public class ExamUserController extends BaseController {

    @Autowired
    private IExamUserService examUserService;

    @Autowired
    private IExamUserScoreService examUserScoreService;

    @Autowired
    private IExamUserScoreDetailService examUserScoreDetailService;

    private Logger log = LoggerFactory.getLogger(ExamUserController.class);

    /**
     * 查询范围（成员）列表
     *
     * @param examUser
     * @return
     */
    @GetMapping("/list/{examId}")
    public TableDataInfo list(@PathVariable("examId") Long examId, ExamUserVo examUser) {
        try {
            examUser.setExamId(examId);
            startPage();
            List<ExamUserVo> list = examUserService.queryList(examUser);
            return getDataTable(list);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            throw new ServiceException("查询时出现异常");
        }
    }

//    /**
//     * 新增
//     *
//     * @param examUser
//     * @return
//     */
//    @PostMapping("/add/{examId}")
//    public AjaxResult add(@PathVariable("examId") Long examId, @RequestBody @Validated ExamUser examUser) {
//        examUser.setExamId(examId);
//        return toAjax(examUserService.save(examUser));
//    }

    /**
     * 新增时弹窗
     *
     * @param examUser
     * @return
     */
    @GetMapping("/addList")
    public TableDataInfo addList(ExamUserVo examUser) {
        try {
            List<Long> userIdList = examUserService.selectAllUserIdByExamId(examUser.getExamId());
            startPage();
            List<ExamUserVo> examUserVoList = examUserService.selectAddList(examUser, userIdList);
            return getDataTable(examUserVoList);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            throw new ServiceException("查询失败");
        }
    }


    /**
     * 新增学员,挂载到当前的问卷范围下
     */
    @PostMapping("/add/{examId}/{userIds}")
    public AjaxResult add(@PathVariable Long examId, @PathVariable Long[] userIds) {
        return toAjax(examUserService.addExamUsers(examId, userIds));
    }



    /**
     * 删除
     *
     * @param ids
     * @return
     */
    @DeleteMapping("/delete/{ids}")
    @Transactional(rollbackFor = Exception.class)
    public AjaxResult delete(@PathVariable("ids") List<Integer> ids) {
        try {
//            LambdaQueryWrapper<ExamUserScore> lwq = new LambdaQueryWrapper<>();
//            lwq.in(ExamUserScore::getUserId, ids);
//            examUserScoreService.remove(lwq);
//            List<ExamUserScore> examUserScoreList = examUserScoreService.list(lwq);
//            List<Long> list = new ArrayList<>();
//            for (ExamUserScore examUserScore : examUserScoreList) {
//                list.add(examUserScore.getUserId());
//            }
//            LambdaQueryWrapper<ExamUserScoreDetail> detailLwq = new LambdaQueryWrapper<>();
//            examUserScoreDetaiService.remove(detailLwq);
            return toAjax(examUserService.removeByIds(ids));
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            throw new ServiceException("删除时出现异常");
        }
    }

    /**
     * 导出
     *
     * @param ids
     * @return
     */
    @PostMapping("/export/{ids}")
    public void export(HttpServletResponse response, @PathVariable("ids") List<Integer> ids) {
        List<ExamUserVo> list = examUserService.export(ids);
        ExcelUtil<ExamUserVo> util = new ExcelUtil<>(ExamUserVo.class);
        util.exportExcel(response, list, "问卷范围");
    }


    /**
     * 导出全部
     *
     * @param response
     * @param examUser
     */
    @PostMapping("/export")
    public void exportAll(HttpServletResponse response, ExamUserVo examUser) {
        List<ExamUserVo> list = examUserService.queryList(examUser);
        ExcelUtil<ExamUserVo> util = new ExcelUtil<>(ExamUserVo.class);
        util.exportExcel(response, list, "问卷范围");
    }
}
