package yangtz.cs.liu.campus.controller.exam;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.domain.entity.SysUser;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.common.exception.base.BaseException;
import com.ruoyi.common.utils.SecurityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.*;
import yangtz.cs.liu.campus.domain.exam.ExamDetail;
import yangtz.cs.liu.campus.domain.exam.ExamUserScore;
import yangtz.cs.liu.campus.domain.exam.ExamUserScoreDetail;
import yangtz.cs.liu.campus.service.exam.IExamDetailService;
import yangtz.cs.liu.campus.service.exam.IExamMainService;
import yangtz.cs.liu.campus.service.exam.IExamUserScoreDetailService;
import yangtz.cs.liu.campus.service.exam.IExamUserScoreDetailService;
import yangtz.cs.liu.campus.service.exam.IExamUserScoreService;
import yangtz.cs.liu.campus.vo.exam.ExamDetailVo;
import yangtz.cs.liu.campus.vo.exam.ExamMainVo;
import yangtz.cs.liu.campus.vo.exam.ScoreVo;

import java.util.List;

import static com.baomidou.mybatisplus.core.toolkit.ObjectUtils.isNotNull;

/**
 * 代办任务
 */
@RequestMapping("/examTasks")
@RestController
public class ExamTasksController extends BaseController {

    @Autowired
    private IExamMainService examMainService;

    @Autowired
    private IExamUserScoreService examUserScoreService;

    @Autowired
    private IExamUserScoreDetailService examUserScoreDetailService;

    @Autowired
    private IExamDetailService examDetailService;

    private Logger log = LoggerFactory.getLogger(ExamTasksController.class);

    /**
     * 查询代办任务
     *
     * @return
     */
    @GetMapping("/list")
    public TableDataInfo list() {
        try {
            startPage();
//        //拿到当前登录用户
//        SysUser user = SecurityUtils.getLoginUser().getUser();
            //getUserId();
            ExamMainVo examMainVo = new ExamMainVo();
            examMainVo.setUserId(getUserId());
            List<ExamMainVo> list = examMainService.selectExamTasks(examMainVo);
            return getDataTable(list);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            throw new ServiceException("查询代办任务时出现异常");
        }

    }

    /**
     * 参加打分功能
     *
     * @param examId
     * @param score
     * @return
     */
    @PostMapping("/join/{examId}")
    public AjaxResult join(@PathVariable("examId") Long examId, @RequestBody ScoreVo score) {
        try {
            examMainService.join(examId, score);
            return AjaxResult.success("操作成功！");
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            throw new ServiceException("参与打分失败!");
        }
    }


}
