package yangtz.cs.liu.campus.controller.epidemic;

import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.common.utils.poi.ExcelUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import yangtz.cs.liu.campus.service.epidemic.IEpidemicUserScoreService;
import yangtz.cs.liu.campus.service.exam.IExamUserScoreService;
import yangtz.cs.liu.campus.vo.epidemic.EpidemicUserScoreVo;
import yangtz.cs.liu.campus.vo.exam.ExamUserScoreVo;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 活动结果
 */
@RestController
@RequestMapping("/epidemicUserScore")
public class EpidemicUserScoreController extends BaseController {

    @Autowired
    private IEpidemicUserScoreService epidemicUserScoreService;

    private Logger log= LoggerFactory.getLogger(EpidemicUserScoreController.class);

    /**
     * 查询活动结果
     *
     * @param epidemicUserScore
     * @return
     */
    @GetMapping("/list/{epidemicId}")
    public TableDataInfo list(@PathVariable("epidemicId")Long epidemicId, EpidemicUserScoreVo epidemicUserScore) {
        try {
            epidemicUserScore.setEpidemicId(epidemicId);
            startPage();
            List<EpidemicUserScoreVo> list = epidemicUserScoreService.selectResult(epidemicUserScore);
            return getDataTable(list);
        }catch (Exception e){
            log.error(e.getMessage(),e);
            throw new ServiceException("查询时出现异常");
        }
    }

    /**
     * 导出
     *
     * @param ids
     * @return
     */
    @PostMapping("/export/{ids}")
    public void export(HttpServletResponse response, @PathVariable("ids") List<Integer> ids) {
        List<EpidemicUserScoreVo> list = epidemicUserScoreService.export(ids);
        ExcelUtil<EpidemicUserScoreVo> util = new ExcelUtil<>(EpidemicUserScoreVo.class);
        util.exportExcel(response, list, "活动结果");
    }

    /**
     * 导出全部
     *
     * @param response
     * @param epidemicUserScore
     */
    @PostMapping("/export")
    public void exportAll(HttpServletResponse response, EpidemicUserScoreVo epidemicUserScore) {
        List<EpidemicUserScoreVo> list = epidemicUserScoreService.selectResult(epidemicUserScore);
        ExcelUtil<EpidemicUserScoreVo> util = new ExcelUtil<>(EpidemicUserScoreVo.class);
        util.exportExcel(response, list, "活动结果");
    }
}
