package yangtz.cs.liu.campus.controller.educationalStatistics;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.TemplateExportParams;
import cn.hutool.core.io.resource.ClassPathResource;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.exception.ServiceException;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import yangtz.cs.liu.campus.service.educationStatistics.IEducationStatisticsService;
import yangtz.cs.liu.campus.service.impl.student.SchoolStudentServiceImpl;
import yangtz.cs.liu.campus.service.schoolClass.ISchoolClassService;
import yangtz.cs.liu.campus.util.TemplateExcelUtils;
import yangtz.cs.liu.campus.vo.educationStatistics.StatisticsVariationVo;

import javax.servlet.http.HttpServletResponse;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@RestController
@RequestMapping("/Educational/variation")
public class StatisticsVariationController extends BaseController {
    @Autowired
    private IEducationStatisticsService statisticsService;

    /**
     * 异动统计
     */

    @GetMapping("/list")
    public TableDataInfo getList(String data,String data1){
        List<StatisticsVariationVo> variationNum = statisticsService.getVariationNum(data, data1);
        return getDataTable(variationNum);
    }
    @PostMapping("/exportGrade")
    public void exportClass(String data,String data1, HttpServletResponse response)
    {
        List<StatisticsVariationVo> variationNum = statisticsService.getVariationNum(data, data1);
        StatisticsVariationVo vo = variationNum.get(0);
        try {

            ClassPathResource classPathResource = new ClassPathResource("template/countVariation.xlsx");
            //获取模板文件绝对路径
            String absolutePath = classPathResource.getAbsolutePath();

            TemplateExportParams params = new TemplateExportParams(TemplateExcelUtils.convertTemplatePath("template/countVariation.xlsx"));

            Map<String, Object> finalMap = new HashMap<String, Object>();
            /*finalMap.put("data",data);
            finalMap.put("data1",data1);
            finalMap.put("VariationList",variationNum);*/
            finalMap.put("Into",vo.getInto());
            finalMap.put("IntoBorrowing",vo.getIntoBorrowing());
            finalMap.put("out",vo.getOut());
            finalMap.put("OutBorrowing",vo.getOutBorrowing());
            finalMap.put("Dropped",vo.getDropped());
            finalMap.put("All",vo.getAll());

            Workbook workbook = ExcelExportUtil.exportExcel(params, finalMap);

            workbook.write(response.getOutputStream());

        } catch (Exception e) {
            throw new ServiceException("下载出错");
        }
    }

}
