package yangtz.cs.liu.campus.controller.curricula;

import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.system.service.ISysDictDataService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import yangtz.cs.liu.campus.service.curricula.ICurriculaStudentService;
import yangtz.cs.liu.campus.vo.curricula.CurriculaStudentCjVo;
import yangtz.cs.liu.campus.vo.curricula.CurriculaStudentVo;
import yangtz.cs.liu.campus.vo.curricula.CurriculaStudentXjVo;
import yangtz.cs.liu.campus.vo.curricula.CurriculaStudentYtVo;

import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;

/**
 * 学生选课情况
 */
@RestController
@RequestMapping("/curricula/student")
public class CurriculaStudentController extends BaseController {

    @Autowired
    private ICurriculaStudentService curriculaStudentService;
    @Autowired
    private ISysDictDataService sysDictDataService;

    /**
     * 查看选课情况列表
     * @param curriculaStudentVo
     * @return
     */
    @GetMapping("/list")
    public TableDataInfo list(CurriculaStudentVo curriculaStudentVo){
        startPage();
        return getDataTable(curriculaStudentService.selectCurriculaStudentList(curriculaStudentVo));
    }

    /**
     * 查看春季选课情况列表
     * @param curriculaStudentVo
     * @return
     */
    @GetMapping("/listCj")
    public TableDataInfo listCj(CurriculaStudentVo curriculaStudentVo){
        startPage();
        return getDataTable(curriculaStudentService.selectCurriculaStudentListCj(curriculaStudentVo));
    }

    /**
     * 查看夏季选课情况列表
     * @param curriculaStudentVo
     * @return
     */
    @GetMapping("/listXj")
    public TableDataInfo listXj(CurriculaStudentVo curriculaStudentVo){
        startPage();
        return getDataTable(curriculaStudentService.selectCurriculaStudentListXj(curriculaStudentVo));
    }

    /**
     * 查看夏季二次分班列表
     * @param curriculaStudentVo
     * @return
     */
    @GetMapping("/listXjEc")
    public TableDataInfo listXjEc(CurriculaStudentVo curriculaStudentVo){
        startPage();
        return getDataTable(curriculaStudentService.selectCurriculaStudentListXjQm(curriculaStudentVo));
    }

    /**
     * 查看艺体选课情况列表
     * @param curriculaStudentVo
     * @return
     */
    @GetMapping("/listYt")
    public TableDataInfo listYt(CurriculaStudentVo curriculaStudentVo){
        startPage();
        return getDataTable(curriculaStudentService.selectCurriculaStudentListYt(curriculaStudentVo));
    }

    /**
     * 导出选课情况列表
     */
    @Log(title = "选课情况", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response,CurriculaStudentVo curriculaStudentVo)
    {
        List<CurriculaStudentVo> list = curriculaStudentService.selectCurriculaStudentList(curriculaStudentVo);
        for (CurriculaStudentVo studentVo : list) {
            if (null != studentVo.getSelectedMajor()){
                if (studentVo.getSelectedMajor().length() > 0){
                    String[] split = studentVo.getSelectedMajor().split(",");
                    String selectedMajorName = "";
                    for (int i=0;i<split.length;i++) {
                        if (i == split.length - 1){
                            selectedMajorName += sysDictDataService.selectDictLabel("specialty",split[i]);
                        }else {
                            selectedMajorName += sysDictDataService.selectDictLabel("specialty",split[i])+ ",";
                        }
                    }
                    studentVo.setSelectedMajorName(selectedMajorName);
                    studentVo.setSelectedMajorSubject(selectedMajorName);
                }
            }
            if (null != studentVo.getSelectedCourse()){
                if (null != studentVo.getSelectedSubject()){
                    String selectedSubject = sysDictDataService.selectDictLabel("art_subject",studentVo.getSelectedSubject());
                    String selectedCourse = sysDictDataService.selectDictLabel("section_type",studentVo.getSelectedCourse());
                    studentVo.setSelectedMajorSubject(selectedSubject+ "," + selectedCourse);
                }else {
                    String selectedCourse = sysDictDataService.selectDictLabel("section_type",studentVo.getSelectedCourse());
                    studentVo.setSelectedMajorSubject(selectedCourse);
                }
            }
        }
        ExcelUtil<CurriculaStudentVo> util = new ExcelUtil<CurriculaStudentVo>(CurriculaStudentVo.class);
        util.exportExcel(response, list, "选课情况数据");
    }

    /**
     * 导出春季选课情况列表
     */
    @Log(title = "春季选课情况", businessType = BusinessType.EXPORT)
    @PostMapping("/exportCj")
    public void exportCj(HttpServletResponse response,CurriculaStudentVo curriculaStudentVo)
    {
        List<CurriculaStudentVo> curriculaStudentVoList = curriculaStudentService.selectCurriculaStudentListCj(curriculaStudentVo);
        List<CurriculaStudentCjVo> list = new ArrayList<>();
        curriculaStudentVoList.forEach(curriculaStudentVo1 -> {
            CurriculaStudentCjVo studentCjVo = new CurriculaStudentCjVo();
            //已选专业
            String[] split = curriculaStudentVo1.getSelectedMajor().split(",");
            String selectedMajorName = "";
            for (int i=0;i<split.length;i++) {
                if (i == split.length - 1){
                    selectedMajorName += sysDictDataService.selectDictLabel("specialty",split[i]);
                }else {
                    selectedMajorName += sysDictDataService.selectDictLabel("specialty",split[i]) + ",";
                }
            }
            curriculaStudentVo1.setSelectedMajorName(selectedMajorName);
            BeanUtils.copyProperties(curriculaStudentVo1,studentCjVo);
            list.add(studentCjVo);
        });
        ExcelUtil<CurriculaStudentCjVo> util = new ExcelUtil<CurriculaStudentCjVo>(CurriculaStudentCjVo.class);
        util.exportExcel(response, list, "选课情况数据");
    }

    /**
     * 导出夏季选课情况列表
     */
    @Log(title = "夏季选课情况", businessType = BusinessType.EXPORT)
    @PostMapping("/exportXj")
    public void exportXj(HttpServletResponse response,CurriculaStudentVo curriculaStudentVo)
    {
        List<CurriculaStudentVo> curriculaStudentVoList = curriculaStudentService.selectCurriculaStudentListXj(curriculaStudentVo);
        List<CurriculaStudentXjVo> list = new ArrayList<>();
        curriculaStudentVoList.forEach(curriculaStudentVo1 -> {
            CurriculaStudentXjVo curriculaStudentXjVo = new CurriculaStudentXjVo();
            BeanUtils.copyProperties(curriculaStudentVo1,curriculaStudentXjVo);
            list.add(curriculaStudentXjVo);
        });
        ExcelUtil<CurriculaStudentXjVo> util = new ExcelUtil<CurriculaStudentXjVo>(CurriculaStudentXjVo.class);
        util.exportExcel(response, list, "选课情况数据");
    }

    /**
     * 导出夏季二次分班情况列表
     */
    @Log(title = "夏季选课情况", businessType = BusinessType.EXPORT)
    @PostMapping("/exportXjEc")
    public void exportXjEc(HttpServletResponse response,CurriculaStudentVo curriculaStudentVo)
    {
        List<CurriculaStudentVo> curriculaStudentVoList = curriculaStudentService.selectCurriculaStudentListXjQm(curriculaStudentVo);
        List<CurriculaStudentXjVo> list = new ArrayList<>();
        curriculaStudentVoList.forEach(curriculaStudentVo1 -> {
            CurriculaStudentXjVo curriculaStudentXjVo = new CurriculaStudentXjVo();
            BeanUtils.copyProperties(curriculaStudentVo1,curriculaStudentXjVo);
            list.add(curriculaStudentXjVo);
        });
        ExcelUtil<CurriculaStudentXjVo> util = new ExcelUtil<CurriculaStudentXjVo>(CurriculaStudentXjVo.class);
        util.exportExcel(response, list, "选课情况数据");
    }

    /**
     * 导出艺体选课情况列表
     */
    @Log(title = "艺体选课情况", businessType = BusinessType.EXPORT)
    @PostMapping("/exportYt")
    public void exportYt(HttpServletResponse response,CurriculaStudentVo curriculaStudentVo)
    {
        List<CurriculaStudentVo> curriculaStudentVoList = curriculaStudentService.selectCurriculaStudentListYt(curriculaStudentVo);
        List<CurriculaStudentYtVo> list = new ArrayList<>();
        curriculaStudentVoList.forEach(curriculaStudentVo1 -> {
            CurriculaStudentYtVo curriculaStudentYtVo = new CurriculaStudentYtVo();
            BeanUtils.copyProperties(curriculaStudentVo1,curriculaStudentYtVo);
            list.add(curriculaStudentYtVo);
        });
        ExcelUtil<CurriculaStudentYtVo> util = new ExcelUtil<CurriculaStudentYtVo>(CurriculaStudentYtVo.class);
        util.exportExcel(response, list, "选课情况数据");
    }

    /**
     * 查看选课情况列表(班主任)
     * @param curriculaStudentVo
     * @return
     */
    @GetMapping("/listBzr")
    public TableDataInfo listBzr(CurriculaStudentVo curriculaStudentVo){
        startPage();
        return getDataTable(curriculaStudentService.selectCurriculaStudentListBzr(curriculaStudentVo));
    }

    /**
     * 导出选课情况列表(班主任)
     */
    @Log(title = "选课情况", businessType = BusinessType.EXPORT)
    @PostMapping("/exportBzr")
    public void exportBzr(HttpServletResponse response,CurriculaStudentVo curriculaStudentVo)
    {
        List<CurriculaStudentVo> list = curriculaStudentService.selectCurriculaStudentListBzr(curriculaStudentVo);
        for (CurriculaStudentVo studentVo : list) {
            if (null != studentVo.getSelectedMajor()){
                if (studentVo.getSelectedMajor().length() > 0){
                    String[] split = studentVo.getSelectedMajor().split(",");
                    String selectedMajorName = "";
                    for (int i=0;i<split.length;i++) {
                        if (i == split.length - 1){
                            selectedMajorName += sysDictDataService.selectDictLabel("specialty",split[i]);
                        }else {
                            selectedMajorName += sysDictDataService.selectDictLabel("specialty",split[i])+ ",";
                        }
                    }
                    studentVo.setSelectedMajorName(selectedMajorName);
                    studentVo.setSelectedMajorSubject(studentVo.getSelectedMajorName());
                }
            }
            if (null != studentVo.getSelectedCourse()){
                if (null != studentVo.getSelectedSubject()){
                    String selectedSubject = sysDictDataService.selectDictLabel("art_subject",studentVo.getSelectedSubject());
                    studentVo.setSelectedSubject(selectedSubject);
                    String selectedCourse = sysDictDataService.selectDictLabel("section_type",studentVo.getSelectedCourse());
                    studentVo.setSelectedCourse(selectedCourse);
                    studentVo.setSelectedMajorSubject(studentVo.getSelectedCourse() + "," + studentVo.getSelectedSubject());
                }
                String selectedCourse = sysDictDataService.selectDictLabel("section_type",studentVo.getSelectedCourse());
                studentVo.setSelectedCourse(selectedCourse);
                studentVo.setSelectedMajorSubject(studentVo.getSelectedCourse());
            }
        }
        ExcelUtil<CurriculaStudentVo> util = new ExcelUtil<CurriculaStudentVo>(CurriculaStudentVo.class);
        util.exportExcel(response, list, "选课情况数据");
    }
}
