package yangtz.cs.liu.campus.controller.course;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.common.utils.poi.ExcelUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import yangtz.cs.liu.campus.domain.course.SchoolCourse;
import yangtz.cs.liu.campus.domain.device.SchoolDevice;
import yangtz.cs.liu.campus.domain.student.SchoolEducation;
import yangtz.cs.liu.campus.domain.student.SchoolStudentEvaluate;
import yangtz.cs.liu.campus.service.course.ISchoolCourseSerivice;
import yangtz.cs.liu.campus.vo.Course.SchoolCourseVO;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 学校课程Controller
 *
 * @author ruoyi
 * @date 2022-10-16
 */
@RestController
@RequestMapping("/school/course")
public class SchoolCourseController extends BaseController {

    @Autowired
    private ISchoolCourseSerivice schoolCourseSerivice;


    /*
     * 获取课程列表
     * */
    @GetMapping("/list")
    public TableDataInfo list(SchoolCourse schoolCourse) {
        startPage();
        List<SchoolCourseVO> list = schoolCourseSerivice.queryList(schoolCourse);
        return getDataTable(list);
    }

    /**
     * 新增
     *
     * @param schoolCourse
     * @return
     */
    @PostMapping("/add")
    public AjaxResult add(@RequestBody @Validated SchoolCourse schoolCourse) {
        return toAjax(schoolCourseSerivice.save(schoolCourse));
    }

    /**
     * 修改
     *
     * @param schoolCourse
     * @return
     */
    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody @Validated SchoolCourse schoolCourse) {
        if (StringUtils.isNull(schoolCourse.getId())) {
            return AjaxResult.error("课程id未传");
        }
        return toAjax(schoolCourseSerivice.updateById(schoolCourse));
    }

    /**
     * 查询详情
     *
     * @param id
     * @return
     */
    @GetMapping("/queryOne/{id}")
    public AjaxResult queryOne(@PathVariable("id") Long id) {
        return AjaxResult.success(schoolCourseSerivice.getById(id));
    }

    /**
     * 删除
     *
     * @param ids
     * @return
     */
    @DeleteMapping("/delete/{ids}")
    @Transactional(rollbackFor = Exception.class)
    public AjaxResult delete(@PathVariable("ids") List<Long> ids) {
        return toAjax(schoolCourseSerivice.removeByIds(ids));
    }

    /**
     * 导出
     *
     * @param ids
     * @return
     */
    @PostMapping("/export/{ids}")
    public void export(HttpServletResponse response, @PathVariable("ids") List<Long> ids) {
        List<SchoolCourse> list = schoolCourseSerivice.listByIds(ids);
        ExcelUtil<SchoolCourse> util = new ExcelUtil<>(SchoolCourse.class);
        util.exportExcel(response, list, "学校课程");
    }
    //导出全部
    @PostMapping("/export")
    public void exportAll(HttpServletResponse response, SchoolCourse schoolCourse) {
        LambdaQueryWrapper<SchoolCourse> lqw = new LambdaQueryWrapper<>();
        lqw
                .orderByDesc(SchoolCourse::getCreateTime)
        ;
        List<SchoolCourse> list = schoolCourseSerivice.list(lqw);
        ExcelUtil<SchoolCourse> util = new ExcelUtil<>(SchoolCourse.class);
        util.exportExcel(response, list, "学校课程");
    }
}
