package yangtz.cs.liu.campus.controller.conference;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.common.utils.poi.ExcelUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import yangtz.cs.liu.campus.domain.conference.SchoolConference;
import yangtz.cs.liu.campus.domain.conference.SchoolConferenceDetails;
import yangtz.cs.liu.campus.service.conference.ISchoolConferenceDetailsService;
import yangtz.cs.liu.campus.service.conference.ISchoolConferenceService;
import yangtz.cs.liu.campus.vo.conference.SchoolConferenceVO;

import javax.servlet.http.HttpServletResponse;
import java.util.Arrays;
import java.util.List;

import static com.ruoyi.common.utils.StringUtils.isNotNull;

@RestController
@RequestMapping("/schoolConference")
public class SchoolConferenceController extends BaseController
{
    @Autowired
    private ISchoolConferenceService schoolConferenceService;

    @Autowired
    private ISchoolConferenceDetailsService schoolConferenceDetailsService;

    /**
     * 查询会议信息列表
     */
    @GetMapping("/list")
    public TableDataInfo list(SchoolConference schoolConference)
    {
        startPage();
        List<SchoolConferenceVO> list = schoolConferenceService.queryList(schoolConference);
        return getDataTable(list);
    }

    /**
     * 导出会议信息列表
     */
    @PostMapping("/export/{ids}")
    public void export(HttpServletResponse response, @PathVariable("ids") List<Long> ids) {
        List<SchoolConference> list = schoolConferenceService.listByIds(ids);
        ExcelUtil<SchoolConference> util = new ExcelUtil<>(SchoolConference.class);
        util.exportExcel(response, list, "会议内容");
    }

    @PostMapping("/export")
    public void exportAll(HttpServletResponse response, SchoolConference schoolConference) {
        LambdaQueryWrapper<SchoolConference> lqw = new LambdaQueryWrapper<>();
        lqw
                .like(isNotNull(schoolConference.getConferenceName()), SchoolConference::getConferenceName, schoolConference.getConferenceName())
                .eq(isNotNull(schoolConference.getStartTime()),SchoolConference::getStartTime,schoolConference.getStartTime())
                .orderByAsc(SchoolConference::getStartTime)
        ;
        List<SchoolConference> list = schoolConferenceService.list(lqw);
        ExcelUtil<SchoolConference> util = new ExcelUtil<>(SchoolConference.class);
        util.exportExcel(response, list, "会议内容");
    }

    /**
     * 获取会议信息详细信息
     */
    @GetMapping(value = "/getInfo/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(schoolConferenceService.getById(id));
    }

    /**
     * 新增会议信息
     */
    @PostMapping("/add")
    public AjaxResult add(@RequestBody @Validated SchoolConference schoolConference)
    {
        return toAjax(schoolConferenceService.save(schoolConference));
    }

    /**
     * 修改会议信息
     */
    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody @Validated SchoolConference schoolConference)
    {
        //判断Id是否为空否则插入失败报异常
        if (StringUtils.isNull(schoolConference.getId())) {
            throw new ServiceException("主键不能为空");
        }
        return toAjax(schoolConferenceService.updateById(schoolConference));
    }

    /**
     * 删除会议信息
     */
    @DeleteMapping("/delete/{ids}")
    @Transactional(rollbackFor = Exception.class)
    public AjaxResult remove(@PathVariable List<Long> ids)
    {
        QueryWrapper<SchoolConferenceDetails> wrapper = new QueryWrapper<>();
        wrapper.in("conference_id",ids);
        schoolConferenceDetailsService.remove(wrapper);
        return toAjax(schoolConferenceService.removeByIds(ids));
    }
}
