package yangtz.cs.liu.campus.controller.area;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.common.utils.poi.ExcelUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import org.springframework.web.multipart.MultipartFile;
import yangtz.cs.liu.campus.domain.area.SchoolAreaDetail;
import yangtz.cs.liu.campus.service.area.ISchoolAreaDetailService;
import yangtz.cs.liu.campus.service.area.ISchoolAreaService;
import yangtz.cs.liu.campus.vo.area.AreaDetailVo;
import yangtz.cs.liu.campus.vo.area.ImportDetailVo;
import yangtz.cs.liu.campus.vo.student.SchoolStudentVO;

import javax.servlet.http.HttpServletResponse;

/**
 * 场地详情信息Controller
 *
 * @author ruoyi
 * @date 2022-09-29
 */
@Api(tags = "场地详情管理")
@RestController
@RequestMapping("/areaDetail")
public class SchoolAreaDetailController extends BaseController {
    @Autowired
    private ISchoolAreaDetailService schoolAreaDetailService;
    @Autowired
    private ISchoolAreaService schoolAreaService;

    /**
     * 查询场地详情信息列表
     */
    @ApiOperation("列表查询")
    @GetMapping("/list")
    public TableDataInfo list(SchoolAreaDetail schoolAreaDetail) {
        startPage();
        List<AreaDetailVo> list = schoolAreaDetailService.queryList(schoolAreaDetail);
        if (list.size() == 0 || list == null) {
           return getDataTable(new ArrayList<>());
        }
        return getDataTable(list);
    }

    /**
     * 通过场地id获取所有场地详情
     */
    @ApiOperation("通过场地id获取所有场地详情")
    @GetMapping("/queryByAreaId/{id}")
    public AjaxResult queryByAreaId(@PathVariable("id") Long id) {
        List<SchoolAreaDetail> list = schoolAreaDetailService.queryByAreaId(id);
        return AjaxResult.success(list);
    }

    /**
     * 新增场地详情信息
     */
    @ApiOperation("新增")
    @PostMapping("/add")
    public AjaxResult add(@RequestBody @Validated SchoolAreaDetail schoolAreaDetail) {
//        Long areaId = schoolAreaService.selectIdByName(schoolAreaDetail.getAreaName());
//        schoolAreaDetail.setAreaId(areaId);
        Long gradeId = schoolAreaDetailService.getGradeId(schoolAreaDetail.getGradeValue(), schoolAreaDetail.getClassValue());
        schoolAreaDetail.setGradeId(gradeId);
        return toAjax(schoolAreaDetailService.save(schoolAreaDetail));
    }

    /**
     * 获取场地详情信息详细信息
     */
    @ApiOperation("id查询")
    @GetMapping("/queryById/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id) {
        AreaDetailVo areaDetailVo = schoolAreaDetailService.queryById(id);
        return AjaxResult.success(areaDetailVo);
    }

    /**
     * 修改场地详情信息
     */
    @ApiOperation("修改")
    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody @Validated SchoolAreaDetail schoolAreaDetail) {
        if (StringUtils.isNull(schoolAreaDetail.getId())) {
            throw new ServiceException("主键不能为空");
        }
        Long gradeId = schoolAreaDetailService.getGradeId(schoolAreaDetail.getGradeValue(), schoolAreaDetail.getClassValue());
        schoolAreaDetail.setGradeId(gradeId);  //年级班级改变，对应班级id改变
        return toAjax(schoolAreaDetailService.updateById(schoolAreaDetail));
    }

    /**
     * 删除场地详情信息
     */
    @ApiOperation("删除")
    @DeleteMapping("/delete/{ids}")
    @Transactional(rollbackFor = Exception.class)
    public AjaxResult delete(@PathVariable List<Long> ids) {
        //级联删除
        return toAjax(schoolAreaDetailService.deleteByIds(ids));
    }


    /**
     * 导出场地详情信息列表
     */
    @ApiOperation("导出excel")
    @PostMapping("/export/{ids}")
    public void export(@PathVariable List<Long> ids, HttpServletResponse response) throws IOException {
        List<AreaDetailVo> list = schoolAreaDetailService.selectExportList(ids);
        ExcelUtil<AreaDetailVo> util = new ExcelUtil<AreaDetailVo>(AreaDetailVo.class);
        util.exportExcel(response, list, "场地详情信息列表");
    }

    /**
     * 导出全部列表
     */
    @ApiOperation("导出excel")
    @PostMapping("/exportAll/{areaId}")
    public void exportAll(@PathVariable Long areaId, HttpServletResponse response) throws IOException {
        List<AreaDetailVo> list = schoolAreaDetailService.selectListByAreaId(areaId);
        ExcelUtil<AreaDetailVo> util = new ExcelUtil<AreaDetailVo>(AreaDetailVo.class);
        util.exportExcel(response, list, "场地详情信息列表");
    }

    /**
     * 导出列表,按查询
     */
    @ApiOperation("导出excel")
    @PostMapping("/exportQuery/{areaId}")
    public void exportQuery(@PathVariable Long areaId, SchoolAreaDetail schoolAreaDetail, HttpServletResponse response) throws IOException {
        schoolAreaDetail.setAreaId(areaId);
        List<AreaDetailVo> list = schoolAreaDetailService.queryList(schoolAreaDetail);
        ExcelUtil<AreaDetailVo> util = new ExcelUtil<AreaDetailVo>(AreaDetailVo.class);
        util.exportExcel(response, list, "场地详情信息列表");
    }

    /*
     * 模板
     * */
    @PostMapping("/importTemplate")
    public void importTemplate(HttpServletResponse response) {
        ExcelUtil<ImportDetailVo> util = new ExcelUtil<ImportDetailVo>(ImportDetailVo.class);
        util.importTemplateExcel(response, "场地详情信息");
    }

    /**
     * 导入excel
     */
    @ApiOperation("导入excel")
    @PostMapping("/importExcel/{areaId}")
    public AjaxResult importExcel(MultipartFile file,@PathVariable Long areaId) throws Exception {
        ExcelUtil<ImportDetailVo> util = new ExcelUtil<ImportDetailVo>(ImportDetailVo.class);
        List<ImportDetailVo> list = util.importExcel(file.getInputStream());
        //先校验
        schoolAreaDetailService.checkImport(list,areaId);
        String message = schoolAreaDetailService.importAreaDetailList(list,areaId);
        return AjaxResult.success(message);
    }

}
