package yangtz.cs.liu.campus.controller.area;


import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.common.utils.poi.ExcelUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import com.ruoyi.common.core.controller.BaseController;
import yangtz.cs.liu.campus.domain.area.SchoolArea;
import yangtz.cs.liu.campus.service.area.ISchoolAreaService;
import yangtz.cs.liu.campus.vo.area.AreaVO;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;

/**
 * 场地信息Controller
 *
 * @author ruoyi
 * @date 2022-09-29
 */
@Api(tags = "场地管理")
@RestController
@RequestMapping("/area")
public class SchoolAreaController extends BaseController {
    @Autowired
    private ISchoolAreaService schoolAreaService;

    /**
     * 查询场地信息列表
     */
//    @ApiOperation("列表查询")
//    @GetMapping("/list")
//    public TableDataInfo list(SchoolArea schoolArea) {
//        startPage();
//        List<SchoolArea> list = schoolAreaService.queryList(schoolArea);
//        return getDataTable(list);
//    }
    @ApiOperation("列表查询")
    @GetMapping("/list")
    public AjaxResult list(SchoolArea schoolArea) {
        startPage();
        List<AreaVO> list = schoolAreaService.queryList(schoolArea);
        return AjaxResult.success(list);
    }

    /**
     * 新增场地信息
     */
    @ApiOperation("新增")
    @PostMapping("/add")
    public AjaxResult add(@RequestBody @Validated SchoolArea schoolArea) {
        Boolean flag = schoolAreaService.checkIsExist(schoolArea);
        //存在
        if (flag) {
            throw new ServiceException("该场地已存在，请勿重复添加");
        }
        SchoolArea area = schoolAreaService.getById(schoolArea.getPid());
        if(StringUtils.isNull(area)){
            schoolArea.setAncestors(schoolArea.getPid().toString());
        }
        if(StringUtils.isNotNull(area)){
            schoolArea.setAncestors(area.getAncestors() + "," + schoolArea.getPid());
        }
        schoolArea.insert();
        return toAjax(schoolAreaService.save(schoolArea));
    }

      /**
     * 获取场地信息详细信息
     */
    @ApiOperation("id查询")
    @GetMapping("/queryById/{id}")
    public AjaxResult queryById(@PathVariable("id") Long id) {
        return AjaxResult.success(schoolAreaService.queryInfo(id));
    }

    /**
     * 修改场地信息
     */
    @ApiOperation("修改")
    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody @Validated SchoolArea schoolArea) {
        if (StringUtils.isNull(schoolArea.getId())) {
            throw new ServiceException("id为空");
        }
        Long id = schoolArea.getId();
        //存在
        if (schoolAreaService.checkIsExist(schoolArea)) {
            throw new ServiceException("该场地已存在，请勿重复添加");
        }
        if (schoolArea.getPid().equals(id))
        {
            return AjaxResult.error("修改场地'" + schoolArea.getAreaName() + "'失败，上级场地不能是自己");
        }
        schoolArea.update();
        return toAjax(schoolAreaService.updateArea(schoolArea));
    }

    /**
     * 删除场地信息
     */
    @ApiOperation("删除")
    @DeleteMapping("/delete/{id}")
    @Transactional(rollbackFor = Exception.class)
    public AjaxResult delete(@PathVariable Long id) {
        if (schoolAreaService.hasChildById(id))
        {
            return AjaxResult.error("存在下级场地,不允许删除");
        }
        return toAjax(schoolAreaService.removeById(id));
    }


    /**
     * 导出选中场地列表
     */
    @ApiOperation("导出excel")
    @PostMapping("/export/{ids}")
    public void export(@PathVariable List<Integer> ids, HttpServletResponse response) throws IOException {
        List<SchoolArea> list = schoolAreaService.listByIds(ids);
        ExcelUtil<SchoolArea> util = new ExcelUtil<SchoolArea>(SchoolArea.class);
        util.exportExcel(response, list, "场地信息列表");
    }

    /**
     * 导出全部
     */
    @ApiOperation("导出excel")
    @PostMapping("/exportAll")
    public void exportAll(HttpServletResponse response) throws IOException {
        List<SchoolArea> list = schoolAreaService.list();
        ExcelUtil<SchoolArea> util = new ExcelUtil<SchoolArea>(SchoolArea.class);
        util.exportExcel(response, list, "场地信息列表");
    }

    /**
     * 导出按条件查询
     */
    @ApiOperation("导出excel")
    @PostMapping("/exportQuery")
    public void exportQuery(SchoolArea schoolArea, HttpServletResponse response) throws IOException {
        List<AreaVO> list = schoolAreaService.queryList(schoolArea);
        ExcelUtil<AreaVO> util = new ExcelUtil<AreaVO>(AreaVO.class);
        util.exportExcel(response, list, "场地信息列表");
    }


}
