package yangtz.cs.liu.campus.controller.SchoolEquipment;

import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import yangtz.cs.liu.campus.service.schoolEquipment.IInStockService;
import yangtz.cs.liu.campus.vo.schoolEquipment.SchoolInStockVo;

/**
 * 设备入库
 */

@RestController
@RequestMapping("/inStock")
public class InStockController extends BaseController {

    @Autowired
    private IInStockService inStockService;

    /**
     * 查看设备入库列表
     * @param schoolInStockVo
     * @return
     */
    @GetMapping("/list")
    public TableDataInfo list(SchoolInStockVo schoolInStockVo){
        startPage();
        return getDataTable(inStockService.selectSchoolInStockVoList(schoolInStockVo));
    }

    /**
     * 查看设备入库详细信息
     * @param id
     * @return
     */
    @GetMapping("/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id){
        return AjaxResult.success(inStockService.selectSchoolInStockVoById(id));
    }
}
